/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.NodeOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserCollectionFilter;
import com.synopsys.arc.jenkins.plugins.ownership.util.userFilters.IUserFilter;
import hudson.model.Node;
import hudson.model.User;
import hudson.slaves.NodeProperty;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOwnerPropertyHelper
extends AbstractOwnershipHelper<NodeProperty> {
    static final NodeOwnerPropertyHelper Instance = new NodeOwnerPropertyHelper();

    @CheckForNull
    private static OwnerNodeProperty getOwnerProperty(@CheckForNull NodeProperty node) {
        return (OwnerNodeProperty)node;
    }

    @Override
    @Nonnull
    public OwnershipDescription getOwnershipDescription(@CheckForNull NodeProperty item) {
        OwnerNodeProperty prop = NodeOwnerPropertyHelper.getOwnerProperty(item);
        OwnershipDescription descr = prop != null ? prop.getOwnership() : null;
        return descr != null ? descr : OwnershipDescription.DISABLED_DESCR;
    }

    @Override
    @Nonnull
    public Collection<User> getPossibleOwners(NodeProperty item) {
        if (OwnershipPlugin.getInstance().isRequiresConfigureRights()) {
            return UserCollectionFilter.filterUsers(User.getAll(), true, new IUserFilter[0]);
        }
        return User.getAll();
    }

    @CheckForNull
    private Node getNode(@Nonnull NodeProperty item) {
        if (item instanceof OwnerNodeProperty) {
            OwnerNodeProperty prop = (OwnerNodeProperty)item;
            return prop.getNode();
        }
        return null;
    }

    @Override
    public String getItemTypeName(NodeProperty item) {
        return "node";
    }

    @Override
    public String getItemDisplayName(NodeProperty item) {
        Node node = this.getNode(item);
        return node != null ? NodeOwnerHelper.Instance.getItemDisplayName(node) : "unknown node";
    }

    @Override
    public String getItemURL(NodeProperty item) {
        Node node = this.getNode(item);
        return node != null ? NodeOwnerHelper.Instance.getItemURL(node) : null;
    }
}

