/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.nodes;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.ItemOwnershipAction;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipPlugin;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.ComputerOwnerHelper;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.security.Permission;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeOwnershipAction
extends ItemOwnershipAction<Computer> {
    public NodeOwnershipAction(Computer owner) {
        super(owner);
    }

    @Override
    public boolean actionIsAvailable() {
        return ((Computer)this.getDescribedItem()).hasPermission(OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP);
    }

    @Override
    public Permission getOwnerPermission() {
        return OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP;
    }

    @Override
    public Permission getProjectSpecificPermission() {
        return OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP;
    }

    @Override
    public IOwnershipHelper<Computer> helper() {
        return ComputerOwnerHelper.Instance;
    }

    @Override
    public OwnershipDescription getOwnership() {
        return this.helper().getOwnershipDescription((Computer)this.getDescribedItem());
    }

    public static String getAbsoluteUrl(@Nonnull Computer computer) {
        String r = Jenkins.getInstance().getRootUrl();
        if (r == null) {
            throw new IllegalStateException("Root URL isn't configured yet. Cannot compute absolute URL.");
        }
        return Util.encode((String)(r + computer.getUrl()));
    }

    public HttpResponse doOwnersSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, UnsupportedEncodingException, ServletException, Descriptor.FormException {
        ((Computer)this.getDescribedItem()).checkPermission(OwnershipPlugin.MANAGE_SLAVES_OWNERSHIP);
        JSONObject jsonOwnership = req.getSubmittedForm().getJSONObject("owners");
        OwnershipDescription descr = OwnershipDescription.parseJSON(jsonOwnership);
        ComputerOwnerHelper.setOwnership((Computer)this.getDescribedItem(), descr);
        return HttpResponses.redirectViaContextPath((String)((Computer)this.getDescribedItem()).getUrl());
    }
}

