/*
 * Decompiled with CFR 0.152.
 */
package com.synopsys.arc.jenkins.plugins.ownership.util;

import com.synopsys.arc.jenkins.plugins.ownership.IOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.model.User;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOwnershipHelper<TObjectType>
implements IOwnershipHelper<TObjectType> {
    protected static final Collection<User> EMPTY_USERS_COLLECTION = new ArrayList<User>(0);

    @Override
    @Nonnull
    public final String getDisplayName(@CheckForNull User usr) {
        return UserStringFormatter.format(usr);
    }

    @Override
    @CheckForNull
    public final String getOwnerEmail(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return UserStringFormatter.formatEmail(descr.getPrimaryOwner());
    }

    @Override
    @Nonnull
    public final String getOwnerLongString(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return descr.isOwnershipEnabled() ? UserStringFormatter.format(descr.getPrimaryOwner()) : "N/A";
    }

    @Override
    @Nonnull
    public final String getOwner(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return descr.isOwnershipEnabled() ? UserStringFormatter.formatShort(descr.getPrimaryOwnerId()) : "N/A";
    }

    @Override
    public final boolean isOwnerExists(@Nonnull TObjectType item) {
        OwnershipDescription descr = this.getOwnershipDescription(item);
        return descr.isOwnershipEnabled() ? descr.hasPrimaryOwner() : false;
    }

    @Override
    public Collection<User> getPossibleOwners(TObjectType item) {
        return EMPTY_USERS_COLLECTION;
    }
}

