/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ownership.model.runs;

import com.synopsys.arc.jenkins.plugins.ownership.OwnershipDescription;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerHelper;
import com.synopsys.arc.jenkins.plugins.ownership.jobs.JobOwnerJobProperty;
import com.synopsys.arc.jenkins.plugins.ownership.nodes.OwnerNodeProperty;
import com.synopsys.arc.jenkins.plugins.ownership.util.AbstractOwnershipHelper;
import com.synopsys.arc.jenkins.plugins.ownership.util.UserStringFormatter;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Run;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunOwnershipHelper
extends AbstractOwnershipHelper<Run> {
    private static final RunOwnershipHelper instance = new RunOwnershipHelper();

    public static RunOwnershipHelper getInstance() {
        return instance;
    }

    @Override
    public String getItemTypeName(Run item) {
        return "run";
    }

    @Override
    public String getItemDisplayName(Run item) {
        return item.getFullDisplayName();
    }

    @Override
    public String getItemURL(Run item) {
        return item.getUrl();
    }

    @Override
    public OwnershipDescription getOwnershipDescription(Run item) {
        return JobOwnerHelper.Instance.getOwnershipDescription(item.getParent());
    }

    public static void setUp(@Nonnull AbstractBuild build, @Nonnull Map<String, String> target, @CheckForNull BuildListener listener, boolean injectJobOwnership, boolean injectNodeOwnership) {
        if (injectJobOwnership) {
            JobOwnerJobProperty prop = JobOwnerHelper.getOwnerProperty(build.getParent());
            OwnershipDescription descr = prop != null ? prop.getOwnership() : OwnershipDescription.DISABLED_DESCR;
            RunOwnershipHelper.getVariables(descr, target, "JOB");
        }
        if (injectNodeOwnership) {
            Node node = build.getBuiltOn();
            if (node == null) {
                assert (false) : "Cannot retrieve node of the build. Probably, it has been deleted";
                if (listener != null) {
                    listener.error("Cannot retrieve node of the build. Probably, it has been deleted. Variables will be ignored.");
                }
                return;
            }
            OwnerNodeProperty prop = (OwnerNodeProperty)node.getNodeProperties().get(OwnerNodeProperty.class);
            OwnershipDescription descr = prop != null ? prop.getOwnership() : OwnershipDescription.DISABLED_DESCR;
            RunOwnershipHelper.getVariables(descr, target, "NODE");
        }
    }

    private static void getVariables(OwnershipDescription descr, Map<String, String> target, String prefix) {
        target.put(prefix + "_OWNER", descr.hasPrimaryOwner() ? descr.getPrimaryOwnerId() : "");
        String ownerEmail = UserStringFormatter.formatEmail(descr.getPrimaryOwnerId());
        target.put(prefix + "_OWNER_EMAIL", ownerEmail != null ? ownerEmail : "");
        StringBuilder coowners = new StringBuilder(target.get(prefix + "_OWNER"));
        StringBuilder coownerEmails = new StringBuilder(target.get(prefix + "_OWNER_EMAIL"));
        for (String userId : descr.getCoownersIds()) {
            if (coowners.length() != 0) {
                coowners.append(",");
            }
            coowners.append(userId);
            String coownerEmail = UserStringFormatter.formatEmail(userId);
            if (coownerEmail == null) continue;
            if (coownerEmails.length() != 0) {
                coownerEmails.append(",");
            }
            coownerEmails.append(coownerEmail);
        }
        target.put(prefix + "_COOWNERS", coowners.toString());
        target.put(prefix + "_COOWNERS_EMAILS", coownerEmails.toString());
    }
}

