/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.exception.TrelloHttpException;
import com.julienvey.trello.impl.http.UrlExpander;
import com.ning.http.client.AsyncCompletionHandler;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.ExecutionException;

public class AsyncTrelloHttpClient
implements TrelloHttpClient {
    private AsyncHttpClient asyncHttpClient;
    private ObjectMapper mapper;

    public AsyncTrelloHttpClient() {
        this(new AsyncHttpClient());
    }

    public AsyncTrelloHttpClient(AsyncHttpClient asyncHttpClient) {
        this.asyncHttpClient = asyncHttpClient;
        this.mapper = new ObjectMapper();
    }

    @Override
    public <T> T get(String url, final Class<T> responseType, String ... params) {
        try {
            ListenableFuture f = this.asyncHttpClient.prepareGet(UrlExpander.expandUrl(url, params)).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient.this.mapper.readValue(response.getResponseBody(), responseType);
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T postForObject(String url, Object object, final Class<T> responseType, String ... params) {
        try {
            byte[] body = this.mapper.writeValueAsBytes(object);
            ListenableFuture f = this.asyncHttpClient.preparePost(UrlExpander.expandUrl(url, params)).setHeader("Content-Type", "application/json").setBody(body).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient.this.mapper.readValue(response.getResponseBody(), responseType);
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public URI postForLocation(String url, Object object, String ... params) {
        try {
            byte[] body = this.mapper.writeValueAsBytes(object);
            ListenableFuture f = this.asyncHttpClient.preparePost(UrlExpander.expandUrl(url, params)).setBody(body).execute((AsyncHandler)new AsyncCompletionHandler<URI>(){

                public URI onCompleted(Response response) throws Exception {
                    String location = response.getHeader("Location");
                    if (location != null) {
                        return URI.create(location);
                    }
                    throw new TrelloHttpException("Location header not set");
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (URI)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T putForObject(String url, Object object, final Class<T> responseType, String ... params) {
        try {
            byte[] body = this.mapper.writeValueAsBytes(object);
            ListenableFuture f = this.asyncHttpClient.preparePut(UrlExpander.expandUrl(url, params)).setBody(body).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient.this.mapper.readValue(response.getResponseBody(), responseType);
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public <T> T delete(String url, final Class<T> responseType, String ... params) {
        try {
            ListenableFuture f = this.asyncHttpClient.prepareDelete(UrlExpander.expandUrl(url, params)).execute((AsyncHandler)new AsyncCompletionHandler<T>(){

                public T onCompleted(Response response) throws Exception {
                    return AsyncTrelloHttpClient.this.mapper.readValue(response.getResponseBody(), responseType);
                }

                public void onThrowable(Throwable t) {
                    throw new TrelloHttpException(t);
                }
            });
            return (T)f.get();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            throw new TrelloHttpException(e);
        }
    }
}

