/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.impl.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.julienvey.trello.NotAuthorizedException;
import com.julienvey.trello.NotFoundException;
import com.julienvey.trello.TrelloBadRequestException;
import com.julienvey.trello.TrelloHttpClient;
import com.julienvey.trello.exception.TrelloHttpException;
import com.julienvey.trello.impl.http.UrlExpander;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class OkHttpTrelloHttpClient
implements TrelloHttpClient {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final MediaType APPLICATION_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static final MediaType APPLICATION_OCTET_STREAM = MediaType.parse((String)"application/octet-stream");
    private final OkHttpClient httpClient;
    private final ObjectMapper objectMapper;

    public OkHttpTrelloHttpClient(OkHttpClient httpClient, ObjectMapper objectMapper) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.objectMapper = Objects.requireNonNull(objectMapper);
    }

    public OkHttpTrelloHttpClient() {
        this(new OkHttpClient(), new ObjectMapper());
    }

    private static Request.Builder requestBuilder(String url, String[] params) {
        return new Request.Builder().header("Accept", APPLICATION_JSON.toString()).url(UrlExpander.expandUrl(url, params));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T get(String url, Class<T> responseType, String ... params) {
        try (Response response = this.httpClient.newCall(OkHttpTrelloHttpClient.requestBuilder(url, params).get().build()).execute();){
            T t = this.readResponse(responseType, response);
            return t;
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T postForObject(String url, Object body, Class<T> responseType, String ... params) {
        try (Response response = this.httpClient.newCall(OkHttpTrelloHttpClient.requestBuilder(url, params).post(this.requestBody(body)).build()).execute();){
            T t = this.readResponse(responseType, response);
            return t;
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    @Override
    public URI postForLocation(String url, Object body, String ... params) {
        URI uRI;
        block8: {
            Response response = this.httpClient.newCall(OkHttpTrelloHttpClient.requestBuilder(url, params).post(this.requestBody(body)).build()).execute();
            try {
                this.checkStatusCode(response);
                String location = Optional.ofNullable(response.header("Location")).orElseThrow(() -> new NullPointerException("Location header is not present!"));
                uRI = URI.create(location);
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TrelloHttpException(e);
                }
            }
            response.close();
        }
        return uRI;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T putForObject(String url, Object body, Class<T> responseType, String ... params) {
        try (Response response = this.httpClient.newCall(OkHttpTrelloHttpClient.requestBuilder(url, params).put(this.requestBody(body)).build()).execute();){
            T t = this.readResponse(responseType, response);
            return t;
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T delete(String url, Class<T> responseType, String ... params) {
        try (Response response = this.httpClient.newCall(OkHttpTrelloHttpClient.requestBuilder(url, params).delete().build()).execute();){
            T t = this.readResponse(responseType, response);
            return t;
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T postFileForObject(String url, File file, Class<T> responseType, String ... params) {
        MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.create((MediaType)APPLICATION_OCTET_STREAM, (File)file)).build();
        try (Response response = this.httpClient.newCall(new Request.Builder().url(UrlExpander.expandUrl(url, params)).post((RequestBody)requestBody).build()).execute();){
            T t = this.readResponse(responseType, response);
            return t;
        }
        catch (IOException e) {
            throw new TrelloHttpException(e);
        }
    }

    private <T> T readResponse(Class<T> responseType, Response response) throws IOException {
        this.checkStatusCode(response);
        ResponseBody body = Optional.ofNullable(response.body()).orElseThrow(() -> new IllegalStateException("Cannot read response body because it is null."));
        try {
            return (T)this.objectMapper.readValue(body.byteStream(), responseType);
        }
        catch (JsonProcessingException e) {
            throw new TrelloHttpException("Cannot parse Trello response.", e);
        }
    }

    private void checkStatusCode(Response response) throws IOException {
        if (response.isSuccessful()) {
            return;
        }
        switch (response.code()) {
            case 400: {
                throw new TrelloBadRequestException(response.body() != null ? response.body().string() : "Bad Request");
            }
            case 401: {
                throw new NotAuthorizedException();
            }
            case 404: {
                throw new NotFoundException("Resource not found: " + response.request().url().uri());
            }
        }
    }

    private RequestBody requestBody(Object object) throws JsonProcessingException {
        byte[] body = object == null ? EMPTY_BYTE_ARRAY : this.objectMapper.writeValueAsBytes(object);
        return RequestBody.create((MediaType)APPLICATION_JSON, (byte[])body);
    }
}

