/*
 * Decompiled with CFR 0.152.
 */
package com.julienvey.trello.utils;

import com.julienvey.trello.domain.Argument;

public class ArgUtils {
    private static final Argument[] NO_ARGUMENTS = new Argument[0];

    private ArgUtils() {
    }

    public static Argument arg(String argName, String argValue) {
        return new Argument(argName, argValue);
    }

    public static Argument[] args(String argName1, String argValue1, String argName2, String argValue2) {
        return new Argument[]{new Argument(argName1, argValue1), new Argument(argName2, argValue2)};
    }

    public static Argument[] args(String ... nameValuePairs) {
        int length = nameValuePairs.length;
        if (length == 0) {
            return NO_ARGUMENTS;
        }
        if ((length & 1) != 0) {
            throw new IllegalArgumentException("Expecting even number of arguments, but got: " + length);
        }
        Argument[] args = new Argument[length >> 1];
        int j = 0;
        for (int i = 0; i < args.length; ++i) {
            args[i] = ArgUtils.arg(nameValuePairs[j++], nameValuePairs[j++]);
        }
        return args;
    }
}

