/*
 * Decompiled with CFR 0.152.
 */
package protocbridge;

import java.io.Serializable;
import java.util.Locale;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.sys.package$;
import scala.util.matching.Regex;

public final class SystemDetector$ {
    public static final SystemDetector$ MODULE$ = new SystemDetector$();
    private static final String UNKNOWN = "unknown";
    private static final Regex X86_64_RE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(x8664|amd64|ia32e|em64t|x64)$"));
    private static final Regex X86_32_RE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(x8632|x86|i[3-6]86|ia32|x32)$"));

    private String UNKNOWN() {
        return UNKNOWN;
    }

    private Regex X86_64_RE() {
        return X86_64_RE;
    }

    private Regex X86_32_RE() {
        return X86_32_RE;
    }

    public String normalizedOs(String s) {
        String string = this.normalize(s);
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        if (string.startsWith("aix")) {
            return "aix";
        }
        if (string.startsWith("hpux")) {
            return "hpux";
        }
        if (string.startsWith("linux")) {
            return "linux";
        }
        if (string.startsWith("osx") || string.startsWith("macosx")) {
            return "osx";
        }
        if (string.startsWith("windows")) {
            return "windows";
        }
        if (string.startsWith("freebsd")) {
            return "freebsd";
        }
        if (string.startsWith("openbsd")) {
            return "openbsd";
        }
        if (string.startsWith("netbsd")) {
            return "netbsd";
        }
        return this.UNKNOWN();
    }

    public String normalizedArch(String s) {
        Option option;
        Option option2;
        String string = this.normalize(s);
        if (string != null && !(option2 = this.X86_64_RE().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(1) == 0) {
            return "x86_64";
        }
        if (string != null && !(option = this.X86_32_RE().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            return "x86_32";
        }
        if ("aarch64".equals(string)) {
            return "aarch_64";
        }
        if ("ppc64le".equals(string)) {
            return "ppcle_64";
        }
        if ("ppc64".equals(string)) {
            return "ppc_64";
        }
        if ("s390x".equals(string)) {
            return "s390x";
        }
        return this.UNKNOWN();
    }

    public String detectedClassifier() {
        String osName = (String)package$.MODULE$.props().getOrElse((Object)"os.name", (Function0 & Serializable)() -> "");
        String osArch = (String)package$.MODULE$.props().getOrElse((Object)"os.arch", (Function0 & Serializable)() -> "");
        System.getProperty("os.name");
        return new StringBuilder(1).append(this.normalizedOs(osName)).append("-").append(this.normalizedArch(osArch)).toString();
    }

    public String normalize(String s) {
        return s.toLowerCase(Locale.US).replaceAll("[^a-z0-9]+", "");
    }

    private SystemDetector$() {
    }
}

