/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.thoughtworks.gauge.ClassInitializer;
import com.thoughtworks.gauge.DefaultClassInitializer;
import java.util.HashMap;
import java.util.Map;

public class ClassInstanceManager {
    private Map<Class<?>, Object> classInstanceMap = new HashMap();
    private static ThreadLocal<ClassInitializer> initializer = new InheritableThreadLocal<ClassInitializer>();

    public ClassInstanceManager() {
        initializer.set(new DefaultClassInitializer());
    }

    public ClassInstanceManager(ClassInitializer classInitializer) {
        initializer.set(classInitializer);
    }

    public Object get(Class<?> declaringClass) throws Exception {
        Object classInstance = this.classInstanceMap.get(declaringClass);
        if (classInstance == null) {
            classInstance = ClassInstanceManager.getInitializer().initialize(declaringClass);
            this.classInstanceMap.put(declaringClass, classInstance);
        }
        return classInstance;
    }

    public static void setClassInitializer(ClassInitializer classInitializer) {
        initializer.set(classInitializer);
    }

    public void clearCache() {
        this.classInstanceMap.clear();
    }

    private static ClassInitializer getInitializer() {
        return initializer.get();
    }
}

