/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge;

import com.github.javaparser.Range;
import com.github.javaparser.ast.body.Parameter;
import com.thoughtworks.gauge.Step;
import com.thoughtworks.gauge.StepValue;
import com.thoughtworks.gauge.Util;
import com.thoughtworks.gauge.scan.StepsUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class StepRegistryEntry {
    private final StepsUtil stepsUtil = new StepsUtil();
    private StepValue stepValue;
    private String fileName;
    private Range span;
    private boolean hasAlias;
    private List<String> aliases;
    private Method methodInfo;
    private String stepText;
    private String name;
    private List<Parameter> parameters;
    private boolean isExternal;
    private String fullyQualifiedName;

    public StepRegistryEntry(StepValue stepValue, Method method, boolean isExternal) {
        this();
        this.stepValue = stepValue;
        this.methodInfo = method;
        this.isExternal = isExternal;
        this.fullyQualifiedName = method.getDeclaringClass().getName() + "." + method.getName();
        String[] stepTexts = method.getAnnotation(Step.class).value();
        this.hasAlias = stepTexts.length > 1;
        this.aliases = this.hasAlias ? Arrays.stream(stepTexts).skip(1L).map(t -> this.getStepText((String)t)).collect(Collectors.toList()) : new ArrayList<String>();
    }

    public StepRegistryEntry() {
    }

    public void setStepValue(StepValue stepValue) {
        this.stepValue = stepValue;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setSpan(Range span) {
        this.span = span;
    }

    public void setHasAlias(boolean hasAlias) {
        this.hasAlias = hasAlias;
    }

    public void setAliases(List<String> aliases) {
        this.aliases = aliases;
    }

    public void setStepText(String stepText) {
        this.stepText = stepText;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMethodInfo(Method method) {
        this.methodInfo = method;
    }

    public boolean getIsExternal() {
        return this.isExternal;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Range getSpan() {
        return this.span;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Method getMethodInfo() {
        return this.methodInfo;
    }

    public StepValue getStepValue() {
        return this.stepValue;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public String getStepText() {
        return this.stepText;
    }

    public boolean getHasAlias() {
        return this.hasAlias;
    }

    public String getName() {
        return this.name;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    private String getStepText(String stepAnnotationText) {
        return this.stepsUtil.getStepText(Util.trimQuotes(stepAnnotationText));
    }
}

