/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ExecutorPool {
    private Map<String, ExecutorService> executors = new ConcurrentHashMap<String, ExecutorService>();

    public ExecutorPool(int size) {
        for (int count = 1; count <= size; ++count) {
            this.executors.put(this.getName(count), Executors.newSingleThreadExecutor());
        }
    }

    private String getName(int count) {
        return "Executor-" + count;
    }

    public void execute(int stream, Runnable task) {
        this.executors.get(this.getName(stream)).execute(task);
    }

    public void stopAfterCompletion() {
        for (Map.Entry<String, ExecutorService> entry : this.executors.entrySet()) {
            entry.getValue().shutdown();
        }
    }
}

