/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution;

import com.thoughtworks.gauge.ClassInstanceManager;
import com.thoughtworks.gauge.execution.AbstractExecutionStage;
import com.thoughtworks.gauge.execution.ExecutionStage;
import com.thoughtworks.gauge.execution.MethodExecutor;
import com.thoughtworks.gauge.execution.parameters.ParametersExtractor;
import com.thoughtworks.gauge.execution.parameters.ParsingException;
import com.thoughtworks.gauge.execution.parameters.parsers.base.ParameterParsingChain;
import com.thoughtworks.gauge.registry.StepRegistry;
import gauge.messages.Messages;
import gauge.messages.Spec;
import java.lang.reflect.Method;
import java.util.List;

public class StepExecutionStage
extends AbstractExecutionStage {
    private ExecutionStage next;
    private Messages.ExecuteStepRequest executeStepRequest;
    private ClassInstanceManager manager;
    private ParametersExtractor parametersExtractor;
    private StepRegistry registry;

    public StepExecutionStage(Messages.ExecuteStepRequest executeStepRequest, ClassInstanceManager manager, ParameterParsingChain chain, StepRegistry registry) {
        this.manager = manager;
        this.executeStepRequest = executeStepRequest;
        this.parametersExtractor = new ParametersExtractor(chain);
        this.registry = registry;
    }

    @Override
    public void setNextStage(ExecutionStage stage) {
        this.next = stage;
    }

    @Override
    public Spec.ProtoExecutionResult execute(Spec.ProtoExecutionResult previousStageResult) {
        if (previousStageResult.getFailed()) {
            return this.executeNext(previousStageResult);
        }
        Spec.ProtoExecutionResult stageResult = this.executeStep();
        return this.executeNext(this.mergeExecResults(previousStageResult, stageResult));
    }

    private Spec.ProtoExecutionResult executeStep() {
        int numberOfParameters;
        Method method = this.registry.get(this.executeStepRequest.getParsedStepText()).getMethodInfo();
        int implementationParamCount = method.getParameterTypes().length;
        if (implementationParamCount != (numberOfParameters = this.executeStepRequest.getParametersCount())) {
            return Spec.ProtoExecutionResult.newBuilder().setFailed(true).setExecutionTime(0L).setErrorMessage(String.format("Argument length mismatch for: %s. Actual Count: [%d], Expected Count: [%d]", this.executeStepRequest.getActualStepText(), implementationParamCount, numberOfParameters)).build();
        }
        MethodExecutor methodExecutor = new MethodExecutor(this.manager);
        return this.executeStepMethod(methodExecutor, method);
    }

    Spec.ProtoExecutionResult executeStepMethod(MethodExecutor methodExecutor, Method method) {
        try {
            List<Spec.Parameter> arguments = this.executeStepRequest.getParametersList();
            return methodExecutor.execute(method, this.parametersExtractor.extract(arguments, method.getParameterTypes()));
        }
        catch (ParsingException e) {
            return e.getExecutionResult();
        }
    }

    @Override
    protected ExecutionStage next() {
        return this.next;
    }
}

