/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.execution.parameters.parsers.converters;

import com.thoughtworks.gauge.Table;
import com.thoughtworks.gauge.execution.parameters.parsers.converters.StringToPrimitiveConverter;
import gauge.messages.Spec;
import java.util.ArrayList;
import java.util.List;

public class TableConverter
implements StringToPrimitiveConverter {
    @Override
    public Object convert(Spec.Parameter source) {
        Spec.ProtoTable protoTable = source.getTable();
        return this.tableFromProto(protoTable);
    }

    private Object tableFromProto(Spec.ProtoTable protoTable) {
        if (protoTable.getHeaders() == null) {
            throw new RuntimeException("Invalid table passed");
        }
        Spec.ProtoTableRow headerRow = protoTable.getHeaders();
        List<String> headers = this.getTableRowFor(headerRow);
        Table table = new Table(headers);
        for (int i = 0; i < protoTable.getRowsCount(); ++i) {
            Spec.ProtoTableRow protoRow = protoTable.getRows(i);
            table.addRow(this.getTableRowFor(protoRow));
        }
        return table;
    }

    private List<String> getTableRowFor(Spec.ProtoTableRow tableRow) {
        ArrayList<String> row = new ArrayList<String>();
        for (int i = 0; i < tableRow.getCellsCount(); ++i) {
            row.add(tableRow.getCells(i));
        }
        return row;
    }
}

