/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.gauge.scan;

import com.thoughtworks.gauge.ClasspathHelper;
import com.thoughtworks.gauge.scan.IScanner;
import java.io.File;
import java.net.URL;
import java.util.jar.JarFile;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;

public class ClasspathScanner {
    private Reflections reflections;

    public void scan(IScanner ... scanners) {
        this.reflections = this.createReflections();
        for (IScanner scanner : scanners) {
            scanner.scan(this.reflections);
        }
    }

    private Reflections createReflections() {
        Vfs.addDefaultURLTypes((Vfs.UrlType)new Vfs.UrlType(){

            public boolean matches(URL url) {
                return "file".equals(url.getProtocol());
            }

            public Vfs.Dir createDir(URL url) throws Exception {
                File file = Vfs.getFile((URL)url);
                return file.isDirectory() ? new SystemDir(file) : new ZipDir(new JarFile(Vfs.getFile((URL)url)));
            }
        });
        ConfigurationBuilder config = new ConfigurationBuilder().setScanners(new Scanner[]{Scanners.MethodsAnnotated, Scanners.SubTypes}).addUrls(ClasspathHelper.getUrls()).filterInputsBy(this::shouldScan);
        return new Reflections((Configuration)config);
    }

    private boolean shouldScan(String s) {
        String[] packages;
        String packagesToScan = System.getenv("package_to_scan");
        if (packagesToScan == null || packagesToScan.isEmpty()) {
            return new FilterBuilder().includePattern(".+\\.class").test(s);
        }
        for (String packageToScan : packages = packagesToScan.split(",")) {
            String regex = String.format(".?\\.??%s\\..+\\.class", packageToScan);
            if (!new FilterBuilder().includePattern(regex).test(s)) continue;
            return true;
        }
        return false;
    }
}

