/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.secrets.server.spring;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.thycotic.secrets.server.spring.SecretServer;
import java.util.Arrays;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.InterceptingClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriBuilderFactory;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplateHandler;

@Component
public class SecretServerFactoryBean
implements FactoryBean<SecretServer>,
InitializingBean {
    public static final String DEFAULT_API_URL_TEMPLATE = "https://%s.secretservercloud.%s/api/v1";
    public static final String DEFAULT_OAUTH2_TOKEN_URL_TEMPLATE = "https://%s.secretservercloud.%s/oauth2/token";
    public static final String DEFAULT_TLD = "com";
    private static final String GRANT_REQUEST_USERNAME_PROPERTY = "username";
    private static final String GRANT_REQUEST_PASSWORD_PROPERTY = "password";
    private static final String GRANT_REQUEST_GRANT_TYPE_PROPERTY = "grant_type";
    private static final String GRANT_REQUEST_GRANT_TYPE = "password";
    private static final String AUTHORIZATION_HEADER_NAME = "Authorization";
    private static final String AUTHORIZATION_TOKEN_TYPE = "Bearer";
    @Value(value="${secret_server.api_root_url_template:https://%s.secretservercloud.%s/api/v1}")
    private String apiRootUrlTemplate;
    @Value(value="${secret_server.api_root_url:#{null}}")
    private String apiRootUrl;
    @Value(value="${secret_server.oauth2.username}")
    private String username;
    @Value(value="${secret_server.oauth2.password}")
    private String password;
    @Value(value="${secret_server.oauth2.token_url_template:https://%s.secretservercloud.%s/oauth2/token}")
    private String tokenUrlTemplate;
    @Value(value="${secret_server.oauth2.token_url:#{null}}")
    private String tokenUrl;
    @Value(value="${secret_server.tenant:#{null}}")
    private String tenant;
    @Value(value="${secret_server.tld:com}")
    private String tld;
    @Autowired(required=false)
    private ClientHttpRequestFactory requestFactory;
    private UriBuilderFactory uriBuilderFactory;

    public void afterPropertiesSet() throws Exception {
        Assert.state((StringUtils.hasText((String)this.apiRootUrlTemplate) && StringUtils.hasText((String)this.tokenUrlTemplate) || StringUtils.hasText((String)this.apiRootUrl) && StringUtils.hasText((String)this.tokenUrl) || StringUtils.hasText((String)this.tenant) ? 1 : 0) != 0, (String)"Either secret_server.tenant or both of either secret_server.api_root_url and secret_server.oauth2.token_url or secret_server.api_root_url_template and secret_server.oauth2.token_url_template must be set.");
        this.tld = this.tld.replaceAll("^\\.*(.*?)\\.*$", "$1");
        this.uriBuilderFactory = new DefaultUriBuilderFactory(UriComponentsBuilder.fromUriString((String)(StringUtils.hasText((String)this.tenant) ? String.format(this.apiRootUrlTemplate.replaceAll("/*$", ""), this.tenant, this.tld) : this.apiRootUrl.replaceAll("/*$", ""))));
        if (this.requestFactory == null) {
            this.requestFactory = new SimpleClientHttpRequestFactory();
        }
    }

    private AccessGrant getAccessGrant() {
        LinkedMultiValueMap request = new LinkedMultiValueMap();
        request.add((Object)GRANT_REQUEST_USERNAME_PROPERTY, (Object)this.username);
        request.add((Object)"password", (Object)this.password);
        request.add((Object)GRANT_REQUEST_GRANT_TYPE_PROPERTY, (Object)"password");
        return (AccessGrant)new RestTemplate().postForObject(StringUtils.hasText((String)this.tenant) ? String.format(this.tokenUrlTemplate.replaceAll("/*$", ""), this.tenant, this.tld) : this.tokenUrl.replaceAll("/*$", ""), (Object)request, AccessGrant.class, new Object[0]);
    }

    public SecretServer getObject() throws Exception {
        SecretServer secretServer = new SecretServer();
        secretServer.setUriTemplateHandler((UriTemplateHandler)this.uriBuilderFactory);
        secretServer.setRequestFactory((ClientHttpRequestFactory)new InterceptingClientHttpRequestFactory(this.requestFactory, Arrays.asList((request, body, execution) -> {
            request.getHeaders().add(AUTHORIZATION_HEADER_NAME, String.format("%s %s", AUTHORIZATION_TOKEN_TYPE, this.getAccessGrant().accessToken));
            return execution.execute(request, body);
        })));
        return secretServer;
    }

    public Class<?> getObjectType() {
        return SecretServer.class;
    }

    static class AccessGrant {
        private String accessToken;
        private String refreshToken;
        private String tokenType;
        private int expiresIn;

        AccessGrant() {
        }

        @JsonProperty(value="access_token")
        public String getAccessToken() {
            return this.accessToken;
        }

        @JsonProperty(value="expires_in")
        public int getExpiresIn() {
            return this.expiresIn;
        }

        @JsonProperty(value="refresh_token")
        public String getRefreshToken() {
            return this.refreshToken;
        }

        @JsonProperty(value="token_type")
        public String getTokenType() {
            return this.tokenType;
        }
    }
}

