/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.helpers;

import com.tibco.bw.maven.plugin.test.dto.AssertionDTO;
import com.tibco.bw.maven.plugin.test.dto.ConditionLanguageDTO;
import com.tibco.bw.maven.plugin.test.dto.MockActivityDTO;
import com.tibco.bw.maven.plugin.test.dto.TestCaseDTO;
import com.tibco.bw.maven.plugin.test.dto.TestSetDTO;
import com.tibco.bw.maven.plugin.test.dto.TestSuiteDTO;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TestFileParser {
    public static TestFileParser INSTANCE = new TestFileParser();
    boolean disableMocking = false;
    boolean disableAssertions = false;
    boolean showFailureDetails = false;

    private TestFileParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectAssertions(String contents, TestSuiteDTO suite, String baseDirectoryPath) throws Exception, FileNotFoundException {
        String assertionMode = "Primitive";
        InputStream is = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            Document document = builder.parse(is);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            String testCaseFile = document.getDocumentElement().getAttribute("location");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"ProcessNode".equals((el = (Element)node).getNodeName())) continue;
                suite.setShowFailureDetails(this.showFailureDetails);
                String processId = el.getAttributes().getNamedItem("Id").getNodeValue();
                String processName = el.getAttributes().getNamedItem("Name").getNodeValue();
                if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
                    BWTestConfig.INSTANCE.getTestCaseWithProcessNameMap().put(testCaseFile, processId);
                }
                String packageName = BWFileUtils.getFileNameWithoutExtn(processId);
                TestSetDTO testset = this.getProcessTestSet(processId, suite);
                testset.setPackageName(packageName);
                TestCaseDTO testcase = new TestCaseDTO();
                testcase.setTestCaseFile(testCaseFile);
                NodeList childNodes = el.getChildNodes();
                block29: for (int j = 0; j < childNodes.getLength(); ++j) {
                    Node gcNode;
                    int k;
                    NodeList gChildNodes;
                    String activityName;
                    String location;
                    Node cNode = childNodes.item(j);
                    if (!(cNode instanceof Element)) continue;
                    Element cEl = (Element)cNode;
                    if ("Assertion".equals(cEl.getNodeName())) {
                        if (this.disableAssertions) continue;
                        assertionMode = null != cEl.getAttributes().getNamedItem("goldOutputFromFile") && "true".equals(cEl.getAttributes().getNamedItem("goldOutputFromFile").getNodeValue()) ? "ActivityWithGoldFile" : (null != cEl.getAttributes().getNamedItem("assertionType") && "Activity".equals(cEl.getAttributes().getNamedItem("assertionType").getNodeValue()) ? "Activity" : "Primitive");
                        AssertionDTO ast = new AssertionDTO();
                        ast.setProcessId(processId);
                        ast.setAssertionMode(assertionMode);
                        location = cEl.getAttributes().getNamedItem("Id").getNodeValue();
                        activityName = cEl.getAttributes().getNamedItem("Name").getNodeValue();
                        ast.setLocation(location);
                        gChildNodes = cEl.getChildNodes();
                        block30: for (k = 0; k < gChildNodes.getLength(); ++k) {
                            gcNode = gChildNodes.item(k);
                            if (!(gcNode instanceof Element)) continue;
                            Element gcEl = (Element)gcNode;
                            switch (gcEl.getNodeName()) {
                                case "Lang": {
                                    String conditionLanguage = gcEl.getLastChild().getTextContent();
                                    if ("urn:oasis:names:tc:wsbpel:2.0:sublang:xslt1.0".equals(conditionLanguage)) {
                                        ast.setConditionLanguage(ConditionLanguageDTO.XSLT10);
                                        continue block30;
                                    }
                                    ast.setConditionLanguage(ConditionLanguageDTO.XSLT20);
                                    continue block30;
                                }
                                case "Expression": {
                                    String expression = null;
                                    if (gcEl.getLastChild() == null) {
                                        throw new Exception("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Activity Assertion Configuration.");
                                    }
                                    expression = gcEl.getLastChild().getTextContent();
                                    String replaceInputFile = null;
                                    String inputFile = null;
                                    if ("ActivityWithGoldFile".equals(assertionMode)) {
                                        inputFile = StringUtils.substringBetween((String)expression, (String)"file:///", (String)"')");
                                        BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Expression - " + expression));
                                        if (inputFile == null) {
                                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Gold File Path. Valid example is - doc('file:///<path-to-file>')"));
                                            throw new Exception("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Gold File Path. Valid example is - doc('file:///<path-to-file>')");
                                        }
                                        File goldInputFile = new File(inputFile);
                                        if (!goldInputFile.isAbsolute()) {
                                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Provided Gold File path is relative " + inputFile));
                                            baseDirectoryPath = baseDirectoryPath.replace("\\", "/");
                                            replaceInputFile = baseDirectoryPath.concat("/" + inputFile);
                                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Absolute File path " + replaceInputFile));
                                            expression = StringUtils.replace((String)expression, (String)inputFile, (String)replaceInputFile);
                                        }
                                        if (null != replaceInputFile) {
                                            inputFile = replaceInputFile;
                                        }
                                    }
                                    if (this.showFailureDetails) {
                                        this.setGoldData(assertionMode, expression, ast, inputFile);
                                    }
                                    ast.setExpression(expression);
                                }
                            }
                        }
                        testcase.getAssertionList().add(ast);
                        continue;
                    }
                    if ("Operation".equals(cEl.getNodeName())) {
                        NodeList gChildNodes2 = cEl.getChildNodes();
                        for (int k2 = 0; k2 < gChildNodes2.getLength(); ++k2) {
                            Element e1;
                            Node gcNode2 = gChildNodes2.item(k2);
                            if (!(gcNode2 instanceof Element) || !"resolvedInput".equals((e1 = (Element)gcNode2).getNodeName())) continue;
                            String inputValue = e1.getAttribute("inputValue");
                            testcase.setXmlInput(inputValue);
                            continue block29;
                        }
                        continue;
                    }
                    if (!"MockActivity".equals(cEl.getNodeName()) && !"MockFault".equals(cEl.getNodeName())) continue;
                    MockActivityDTO mockActivity = new MockActivityDTO();
                    location = cEl.getAttributes().getNamedItem("Id").getNodeValue();
                    activityName = cEl.getAttributes().getNamedItem("Name").getNodeValue();
                    mockActivity.setLocation(location);
                    gChildNodes = cEl.getChildNodes();
                    for (k = 0; k < gChildNodes.getLength(); ++k) {
                        boolean isValidFile;
                        Element e1;
                        gcNode = gChildNodes.item(k);
                        if (!(gcNode instanceof Element) || !"MockOutputFilePath".equals((e1 = (Element)gcNode).getNodeName())) continue;
                        String mockOutputFilePath = e1.getTextContent();
                        if (mockOutputFilePath == null || mockOutputFilePath.trim().length() == 0) {
                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Mock Output File Path - " + mockOutputFilePath));
                            throw new Exception("Process : " + processName + ", Activity : " + activityName + ", Id : " + location + ", Error : Invalid Mock Output File Path - " + mockOutputFilePath);
                        }
                        File file = new File(mockOutputFilePath);
                        if (!file.isAbsolute()) {
                            BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Provided Mock File path is relative " + file.getPath()));
                            mockOutputFilePath = baseDirectoryPath.concat("/" + mockOutputFilePath);
                        }
                        if (this.disableMocking || !(isValidFile = this.validateMockXMLFile(mockOutputFilePath, activityName, processName))) continue;
                        mockActivity.setmockOutputFilePath(mockOutputFilePath);
                        testcase.setmockOutputFilePath(mockOutputFilePath);
                        testcase.getMockActivityList().add(mockActivity);
                        continue block29;
                    }
                }
                if (this.disableMocking) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## Mocking will be disabled for all Mocked Activities. DisableMocking :" + this.disableMocking + " ##"));
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                }
                if (this.disableAssertions) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("## All Assertions will be disabled. DisableAssertions :" + this.disableAssertions + " ##"));
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)"-----------------------------------------------------------------------------------------------");
                }
                if (testcase.getAssertionList().isEmpty() && testcase.getMockActivityList().isEmpty() && !this.disableMocking && !this.disableAssertions) {
                    BWTestConfig.INSTANCE.getLogger().info((CharSequence)("No assertions and Mock Activities found in the Test File : " + testcase.getTestCaseFile() + " . Skipping the running of file."));
                    continue;
                }
                testset.getTestCaseList().add(testcase);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void setGoldData(String assertionMode, String expression, AssertionDTO ast, String inputFile) {
        switch (assertionMode) {
            case "Primitive": {
                String goldValueWithElement = StringUtils.substringBetween((String)expression, (String)"test=\"", (String)"\">");
                String goldValue = StringUtils.substringAfter((String)goldValueWithElement, (String)"=");
                if (goldValue.contains("'")) {
                    goldValue = StringUtils.substringBetween((String)goldValue, (String)"'");
                }
                String elementNameString = StringUtils.substringBefore((String)goldValueWithElement, (String)"=");
                String[] elementNameArray = StringUtils.split((String)elementNameString, (String)"/");
                String elementName = elementNameArray[elementNameArray.length - 1];
                String startElementTag = "<".concat(elementName).concat(">");
                String endElementTag = "</".concat(elementName).concat(">");
                ast.setGoldInput(startElementTag.concat(goldValue).concat(endElementTag));
                ast.setStartElementNameTag(startElementTag);
                ast.setEndElementNameTag(endElementTag);
                break;
            }
            case "Activity": {
                String activityGoldValue = StringUtils.substringBetween((String)expression, (String)"<xsl:variable name=\"AssertType\" as=\"item()*\"><Activity-Assertion>", (String)"</Activity-Assertion>");
                activityGoldValue = StringUtils.replace((String)activityGoldValue, (String)"<xsl:value-of select=\"&quot;", (String)"");
                activityGoldValue = StringUtils.replace((String)activityGoldValue, (String)"&quot;\"  />", (String)"");
                ast.setGoldInput(activityGoldValue);
                break;
            }
            case "ActivityWithGoldFile": {
                ast.setGoldInput(this.readXMLFile(inputFile));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<String> collectSkipInitActivities(String contents) {
        InputStream is = null;
        HashSet<String> skipInitActivitiesSet = new HashSet<String>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            is = new ByteArrayInputStream(contents.getBytes(StandardCharsets.UTF_8));
            Document document = builder.parse(is);
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (!(node instanceof Element) || !"ProcessNode".equals((el = (Element)node).getNodeName())) continue;
                String processId = el.getAttributes().getNamedItem("Id").getNodeValue();
                String key = "-D" + processId + "=true";
                skipInitActivitiesSet.add(key);
                NodeList childNodes = el.getChildNodes();
                for (int j = 0; j < childNodes.getLength(); ++j) {
                    String activityName;
                    Element cEl;
                    Node cNode = childNodes.item(j);
                    if (!(cNode instanceof Element) || !"MockActivity".equals((cEl = (Element)cNode).getNodeName())) continue;
                    MockActivityDTO mockActivity = new MockActivityDTO();
                    String location = cEl.getAttributes().getNamedItem("Id").getNodeValue();
                    mockActivity.setLocation(location);
                    if (this.disableMocking || null == (activityName = cEl.getAttributes().getNamedItem("Name").getNodeValue())) continue;
                    skipInitActivitiesSet.add("-D" + processId + activityName + "=true");
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return skipInitActivitiesSet;
    }

    private boolean validateMockXMLFile(String mockOutputFilePath, String activityName, String processName) throws Exception {
        File mockOutputFile = new File(mockOutputFilePath);
        if (mockOutputFile.exists()) {
            try {
                String mockOutputString = this.readXMLFile(mockOutputFilePath);
                DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(mockOutputString)));
                return true;
            }
            catch (Exception e) {
                String errorMessage = "Process : " + processName + ", Activity : " + activityName + "Error : Provided XML file " + mockOutputFilePath + " is not valid";
                BWTestConfig.INSTANCE.getLogger().error((CharSequence)errorMessage, (Throwable)e);
                throw e;
            }
        }
        String errorMessage = "Process : " + processName + ", Activity : " + activityName + ", Error: Provided XML file " + mockOutputFilePath + " is not Present";
        BWTestConfig.INSTANCE.getLogger().error((CharSequence)errorMessage, (Throwable)new FileNotFoundException());
        throw new Exception();
    }

    private String readXMLFile(String mockOutputFilePath) {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(mockOutputFilePath));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                sb.append(sCurrentLine);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return sb.toString();
    }

    public void setdisbleMocking(boolean disableMocking) {
        this.disableMocking = disableMocking;
    }

    public void setdisbleAssertions(boolean disableAssertions) {
        this.disableAssertions = disableAssertions;
    }

    public void setshowFailureDetails(boolean showFailureDetails) {
        this.showFailureDetails = showFailureDetails;
    }

    public boolean getshowFailureDetails() {
        return this.showFailureDetails;
    }

    private TestSetDTO getProcessTestSet(String processName, TestSuiteDTO suite) {
        for (int i = 0; i < suite.getTestSetList().size(); ++i) {
            if (suite.getTestSetList().get(i) == null || !((TestSetDTO)suite.getTestSetList().get(i)).getProcessName().equals(processName)) continue;
            return (TestSetDTO)suite.getTestSetList().get(i);
        }
        TestSetDTO set = new TestSetDTO();
        set.setProcessName(processName);
        suite.getTestSetList().add(set);
        return set;
    }
}

