/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.process;

import com.tibco.bw.maven.plugin.utils.BWProjectUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="bwdesignUtility")
public class BWDesignUtilityExecutorMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="diagramLoc", defaultValue="")
    private String diagramLoc;
    @Parameter(property="commandName", defaultValue="")
    private String commandName;
    @Parameter(property="arguments", defaultValue="")
    private String arguments;
    private Log logger = this.getLog();
    String executorHome = null;
    String tibcoHome = null;
    String bwHome = null;
    String binDir = null;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getPackaging().equals("bwear")) {
            if (null == this.project.getProperties().getProperty("tibco.Home") || this.project.getProperties().getProperty("tibco.Home").isEmpty()) {
                this.logger.error((CharSequence)"Please provide the Tibco Home in POM ");
                throw new MojoFailureException("Value for Tibco Home is empty");
            }
            this.tibcoHome = this.project.getProperties().getProperty("tibco.Home");
            if (null == this.project.getProperties().getProperty("bw.Home") || this.project.getProperties().getProperty("bw.Home").isEmpty()) {
                this.logger.error((CharSequence)"Please provide the BW Home in POM ");
                throw new MojoFailureException("Value for BW Home is empty");
            }
            this.bwHome = this.project.getProperties().getProperty("bw.Home");
            this.executorHome = this.binDir = this.tibcoHome.concat(this.bwHome).concat(File.separator).concat("bin");
            if (null != this.commandName && this.commandName.equals("validate")) {
                this.importWorkspace();
                this.validateBWProject();
            } else if (null != this.commandName && this.commandName.equals("gen_diagrams")) {
                this.importWorkspace();
                this.generateProcessDiagram();
            } else if (null != this.commandName && this.commandName.trim().length() > 0) {
                this.importWorkspace();
                this.executeCommand();
            } else {
                this.importWorkspace();
                this.validateBWProject();
                this.generateProcessDiagram();
            }
        }
    }

    private void executeCommand() throws MojoExecutionException {
        List<String> params = new ArrayList<String>();
        params = this.createUtilityArgument(params);
        params.add(this.commandName);
        if (this.arguments != null && !this.arguments.isEmpty()) {
            params.add(this.arguments);
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.directory(new File(this.executorHome));
            if (BWProjectUtils.OS.WINDOWS.equals((Object)BWProjectUtils.getOS())) {
                builder.redirectError(new File("NUL"));
            } else {
                builder.redirectError(new File("/dev/null"));
            }
            Process process = builder.start();
            this.logger.info((CharSequence)("--------------------- Executing BWDesign Utility Command : " + this.commandName + " -----------------------"));
            this.logger.debug((CharSequence)("Launching bwdesign utility with params: " + params));
            this.printProcessOutput(process);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void generateProcessDiagram() throws MojoExecutionException {
        List<String> params = new ArrayList<String>();
        params = this.createUtilityArgument(params);
        params.add("diagram:gen_diagrams");
        params.add(this.project.getName());
        if (null != this.diagramLoc && !this.diagramLoc.isEmpty()) {
            params.add(this.diagramLoc);
        }
        try {
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.directory(new File(this.executorHome));
            if (BWProjectUtils.OS.WINDOWS.equals((Object)BWProjectUtils.getOS())) {
                builder.redirectError(new File("NUL"));
            } else {
                builder.redirectError(new File("/dev/null"));
            }
            Process process = builder.start();
            this.logger.info((CharSequence)"---------------------Generating Process diagram-----------------------");
            this.logger.debug((CharSequence)("Launching bwdesign utility with params: " + params));
            this.printProcessOutput(process);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private List<String> createUtilityArgument(List<String> params) {
        String utilityName = this.executorHome.concat(File.separator).concat("bwdesign.exe");
        if (BWProjectUtils.OS.UNIX.equals((Object)BWProjectUtils.getOS())) {
            utilityName = this.executorHome.concat(File.separator).concat("bwdesign");
        }
        String workSpaceLocation = this.project.getBasedir().getParent();
        params.add(utilityName);
        params.add("-data");
        params.add(workSpaceLocation);
        return params;
    }

    private void validateBWProject() throws MojoExecutionException {
        List<String> params = new ArrayList<String>();
        params = this.createUtilityArgument(params);
        params.add("validate");
        params.add(this.projectList());
        try {
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.directory(new File(this.executorHome));
            if (BWProjectUtils.OS.WINDOWS.equals((Object)BWProjectUtils.getOS())) {
                builder.redirectError(new File("NUL"));
            } else {
                builder.redirectError(new File("/dev/null"));
            }
            this.logger.info((CharSequence)"---------------------Validating BW Project-----------------------");
            this.logger.debug((CharSequence)("Launching bwdesign utility with params: " + params));
            Process process = builder.start();
            this.printProcessOutput(process);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void importWorkspace() throws MojoExecutionException {
        List<String> params = new ArrayList<String>();
        params = this.createUtilityArgument(params);
        params.add("import");
        params.add(this.project.getBasedir().getParent());
        try {
            ProcessBuilder builder = new ProcessBuilder(params);
            builder.directory(new File(this.executorHome));
            if (BWProjectUtils.OS.WINDOWS.equals((Object)BWProjectUtils.getOS())) {
                builder.redirectError(new File("NUL"));
            } else {
                builder.redirectError(new File("/dev/null"));
            }
            Process process = builder.start();
            this.logger.info((CharSequence)"-----------------Import Projects to Workspaces-------------------");
            this.logger.debug((CharSequence)("Launching bwdesign utility with params: " + params));
            this.printProcessOutput(process);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private String projectList() {
        ArrayList<String> projectList = new ArrayList<String>();
        for (MavenProject mvnProject : this.session.getProjects()) {
            projectList.add(mvnProject.getName());
        }
        return String.join((CharSequence)",", projectList);
    }

    private void printProcessOutput(Process process) throws IOException {
        BufferedReader reader = null;
        String line = null;
        reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = reader.readLine()) != null) {
            this.logger.info((CharSequence)line);
        }
        reader.close();
    }
}

