/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.helpers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class BWTestConfig {
    public static BWTestConfig INSTANCE = new BWTestConfig();
    private File configDir;
    private Process engineProcess;
    private List<String> launchConfig;
    private Map<MavenProject, List<File>> testCasesList = new HashMap<MavenProject, List<File>>();
    private Map<MavenProject, Map<String, List<File>>> testSuiteMap = new HashMap<MavenProject, Map<String, List<File>>>();
    private String tibcoHome;
    private String bwHome;
    private String testSuiteName;
    private MavenSession session;
    private MavenProject project;
    private Log logger;
    public HashMap<String, String> testCaseWithProcessNameMap = new HashMap();
    public Map<MavenProject, List<String>> testSuiteNameList = new HashMap<MavenProject, List<String>>();
    Map<String, Boolean> userTestSuiteNames = new HashMap<String, Boolean>();

    private BWTestConfig() {
    }

    public void reset() {
        INSTANCE = new BWTestConfig();
    }

    public void init(String tibcoHome, String bwHome, MavenSession session, MavenProject project, Log logger) throws Exception {
        this.tibcoHome = tibcoHome;
        this.session = session;
        this.project = project;
        this.bwHome = bwHome;
        this.logger = logger;
        this.initConfig();
    }

    private void initConfig() throws Exception {
        String temp = System.getProperty("java.io.tmpdir");
        File file = new File(temp);
        this.configDir = new File(file, "bwconfig");
        this.configDir.mkdir();
        FileUtils.cleanDirectory((File)this.configDir);
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public void setConfigDir(File configDir) {
        this.configDir = configDir;
    }

    public Process getEngineProcess() {
        return this.engineProcess;
    }

    public void setEngineProcess(Process engineProcess) {
        this.engineProcess = engineProcess;
    }

    public List<String> getLaunchConfig() {
        return this.launchConfig;
    }

    public void setLaunchConfig(List<String> launchConfig) {
        this.launchConfig = launchConfig;
    }

    public String getTibcoHome() {
        return this.tibcoHome;
    }

    public void setTibcoHome(String tibcoHome) {
        this.tibcoHome = tibcoHome;
    }

    public String getBwHome() {
        return this.bwHome;
    }

    public void setBwHome(String bwHome) {
        this.bwHome = bwHome;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public Log getLogger() {
        return this.logger;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public String getTestSuiteName() {
        return this.testSuiteName;
    }

    public void setTestSuiteName(String testSuiteName) {
        this.testSuiteName = testSuiteName;
    }

    public List<File> getTestCasesList(MavenProject project) {
        return this.testCasesList.get(project);
    }

    public void setTestCasesList(MavenProject project, List<File> testCasesList) {
        this.testCasesList.put(project, testCasesList);
    }

    public Map<String, List<File>> getTestSuiteMap(MavenProject project) {
        return this.testSuiteMap.get(project);
    }

    public void setTestSuiteMap(MavenProject project, Map<String, List<File>> testSuiteMap) {
        this.testSuiteMap.put(project, testSuiteMap);
    }

    public HashMap<String, String> getTestCaseWithProcessNameMap() {
        return this.testCaseWithProcessNameMap;
    }

    public void setTestCaseWithProcessNameMap(HashMap<String, String> testCaseWithProcessNameMap) {
        this.testCaseWithProcessNameMap = testCaseWithProcessNameMap;
    }

    public List<String> getTestSuiteNameList(MavenProject project) {
        return this.testSuiteNameList.get(project);
    }

    public void setTestSuiteNameList(MavenProject project, List<String> testSuiteNameList) {
        this.testSuiteNameList.put(project, testSuiteNameList);
    }

    public Map<String, Boolean> getUserTestSuiteNames() {
        return this.userTestSuiteNames;
    }

    public void setUserTestSuiteNames(Map<String, Boolean> userTestSuiteNames) {
        this.userTestSuiteNames = userTestSuiteNames;
    }
}

