/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.report;

import com.tibco.bw.maven.plugin.test.dto.CompleteReportDTO;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.helpers.TestFileParser;
import com.tibco.bw.maven.plugin.test.report.BWTestReportGenerator;
import com.tibco.bw.maven.plugin.test.report.CodeCoverageReportGenerator;
import java.io.File;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

@Mojo(name="bwreport", inheritByDefault=false)
@Execute(lifecycle="bwtestreport", phase=LifecyclePhase.TEST)
public class BWTestsReport
extends AbstractMavenReport {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="showFailureDetails", defaultValue="false")
    private boolean showFailureDetails;
    @Parameter(property="testSuiteName", defaultValue="")
    private String testSuiteName;

    public String getDescription(Locale arg0) {
        return "BW Test Report";
    }

    public String getName(Locale arg0) {
        return "bwtest";
    }

    public String getOutputName() {
        return "bwtest";
    }

    public void execute() throws MojoExecutionException {
        super.execute();
    }

    private void generateCodeCoverageReport(CompleteReportDTO result) throws Exception {
        String fileName = "bwcoverage.html";
        SinkFactory factory = this.getSinkFactory();
        Sink renderSink = factory.createSink(this.outputDirectory, fileName);
        CodeCoverageReportGenerator cgen = new CodeCoverageReportGenerator();
        cgen.generateReport(result, renderSink);
        renderSink.close();
    }

    protected void executeReport(Locale arg0) throws MavenReportException {
        BWTestConfig.INSTANCE.reset();
        String tibcoHome = "";
        String bwHome = "";
        Log logger = this.getLog();
        try {
            BWTestConfig.INSTANCE.init(tibcoHome, bwHome, this.session, this.getProject(), logger);
            TestFileParser.INSTANCE.setshowFailureDetails(this.showFailureDetails);
            BWTestConfig.INSTANCE.setTestSuiteName(this.testSuiteName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CompleteReportDTO result = this.loadTestSuite();
        try {
            this.generateCodeCoverageReport(result);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        BWTestReportGenerator gen = new BWTestReportGenerator();
        gen.generateReport(result, this.getSink());
    }

    private CompleteReportDTO loadTestSuite() {
        File file = new File(BWTestConfig.INSTANCE.getProject().getBasedir(), "target/bwtest/bwtestreport.xml");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{CompleteReportDTO.class});
            Unmarshaller marshaller = jaxbContext.createUnmarshaller();
            CompleteReportDTO result = (CompleteReportDTO)marshaller.unmarshal(file);
            return result;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }
}

