/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.test.setuplocal;

import com.tibco.bw.maven.plugin.test.helpers.BWMFileParser;
import com.tibco.bw.maven.plugin.test.helpers.BWTestConfig;
import com.tibco.bw.maven.plugin.test.helpers.TestFileParser;
import com.tibco.bw.maven.plugin.test.rest.BWTestRunner;
import com.tibco.bw.maven.plugin.test.setuplocal.ConfigFileGenerator;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineLaunchConfigurator;
import com.tibco.bw.maven.plugin.test.setuplocal.EngineRunner;
import com.tibco.bw.maven.plugin.testsuite.BWTestSuiteLoader;
import com.tibco.bw.maven.plugin.utils.BWFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class BWTestExecutor {
    public static BWTestExecutor INSTANCE = new BWTestExecutor();
    int engineDebugPort;
    int engineStartupWaitTime;
    List<String> osgiCommands;
    boolean skipInitMainProcessActivities;
    boolean skipInitAllNonTestProcessActivities;
    List<String> mockActivity = new ArrayList<String>();

    public void execute() throws MojoFailureException, Exception {
        try {
            this.initialize();
            this.runEngine();
            this.runTests();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (BWTestConfig.INSTANCE.getEngineProcess() != null) {
                BWTestConfig.INSTANCE.getEngineProcess().destroyForcibly();
            }
            if (BWTestConfig.INSTANCE.getConfigDir() != null) {
                BWTestConfig.INSTANCE.getConfigDir().delete();
            }
        }
    }

    public void collectSkipInitActivityName() throws Exception, FileNotFoundException {
        List projects = BWTestConfig.INSTANCE.getSession().getProjects();
        if (null != BWTestConfig.INSTANCE.getTestSuiteName() && !BWTestConfig.INSTANCE.getTestSuiteName().isEmpty()) {
            String[] testSuiteNames = BWTestConfig.INSTANCE.getTestSuiteName().contains("/") ? StringUtils.splitByWholeSeparator((String)BWTestConfig.INSTANCE.getTestSuiteName(), (String)"/") : new String[]{BWTestConfig.INSTANCE.getTestSuiteName()};
            HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
            for (String testSuite : testSuiteNames) {
                hashMap.put(testSuite, false);
            }
            BWTestConfig.INSTANCE.setUserTestSuiteNames(hashMap);
        }
        for (MavenProject mavenProject : projects) {
            List<File> files;
            if (!mavenProject.getPackaging().equals("bwmodule")) continue;
            File baseDir = mavenProject.getBasedir();
            if (!BWTestConfig.INSTANCE.getUserTestSuiteNames().isEmpty()) {
                BWTestSuiteLoader testSuiteLoader = new BWTestSuiteLoader();
                files = testSuiteLoader.collectTestCasesList(baseDir.toString(), mavenProject);
            } else {
                files = BWFileUtils.getEntitiesfromLocation(baseDir.toString(), "bwt");
            }
            BWTestConfig.INSTANCE.setTestCasesList(mavenProject, files);
            for (File file : files) {
                HashSet<Object> tempSkipSet = new HashSet();
                String assertionxml = FileUtils.readFileToString((File)file);
                tempSkipSet = TestFileParser.INSTANCE.collectSkipInitActivities(assertionxml);
                if (tempSkipSet.isEmpty()) continue;
                this.mockActivity.addAll(tempSkipSet);
                INSTANCE.setMockActivityList(this.mockActivity);
            }
            List<File> bwmfiles = BWFileUtils.getEntitiesfromLocation(baseDir.toString(), "bwm");
            for (File file : bwmfiles) {
                BWTestConfig.INSTANCE.getLogger().debug((CharSequence)("Parsing bwm file -> " + file.getPath()));
                HashSet<Object> tempSkipSet = new HashSet();
                String scaxml = FileUtils.readFileToString((File)file);
                tempSkipSet = BWMFileParser.INSTANCE.collectMainProcesses(scaxml);
                if (tempSkipSet.isEmpty()) continue;
                this.mockActivity.addAll(tempSkipSet);
                INSTANCE.setMockActivityList(this.mockActivity);
            }
        }
        if (BWTestConfig.INSTANCE.getUserTestSuiteNames().containsValue(false)) {
            for (Map.Entry entry : BWTestConfig.INSTANCE.getUserTestSuiteNames().entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                throw new Exception("Test Suite not found - " + (String)entry.getKey());
            }
        }
    }

    private void initialize() throws Exception {
        this.collectSkipInitActivityName();
        EngineLaunchConfigurator config = new EngineLaunchConfigurator();
        config.loadConfiguration();
        ConfigFileGenerator gen = new ConfigFileGenerator();
        gen.generateConfig();
    }

    private void runEngine() throws Exception {
        EngineRunner runner = new EngineRunner(INSTANCE.getEngineStartupWaitTime(), INSTANCE.getOsgiCommands());
        runner.run();
    }

    private void runTests() throws MojoFailureException, Exception {
        BWTestRunner runner = new BWTestRunner("localhost", INSTANCE.getEngineDebugPort());
        runner.runTests();
    }

    public void setEngineDebugPort(int engineDebugPort) {
        this.engineDebugPort = engineDebugPort;
    }

    public int getEngineDebugPort() {
        return this.engineDebugPort;
    }

    public List<String> getMockActivityList() {
        return this.mockActivity;
    }

    public void setMockActivityList(List<String> mockActivity) {
        this.mockActivity = mockActivity;
    }

    public int getEngineStartupWaitTime() {
        return this.engineStartupWaitTime;
    }

    public void setEngineStartupWaitTime(int engineStartupWaitTime) {
        this.engineStartupWaitTime = engineStartupWaitTime;
    }

    public List<String> getOsgiCommands() {
        return this.osgiCommands;
    }

    public void setOsgiCommands(List<String> osgiCommands) {
        this.osgiCommands = osgiCommands;
    }

    public boolean isSkipInitMainProcessActivities() {
        return this.skipInitMainProcessActivities;
    }

    public void setSkipInitMainProcessActivities(boolean skipInitMainProcessActivities) {
        this.skipInitMainProcessActivities = skipInitMainProcessActivities;
    }

    public boolean isSkipInitAllNonTestProcessActivities() {
        return this.skipInitAllNonTestProcessActivities;
    }

    public void setSkipInitAllNonTestProcessActivities(boolean skipInitAllNonTestProcessActivities) {
        this.skipInitAllNonTestProcessActivities = skipInitAllNonTestProcessActivities;
    }
}

