/*
 * Decompiled with CFR 0.152.
 */
package com.tibco.bw.maven.plugin.testsuite;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.tibco.bw.maven.plugin.testsuite.BWTSModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Scanner;

public class YMLBWTSFileReader {
    public static BWTSModel getModelFrom(Path filePath) throws JsonParseException, JsonMappingException, IOException {
        YAMLMapper mapper = new YAMLMapper();
        String contents = YMLBWTSFileReader.contentsOf(filePath);
        BWTSModel bwtsModel = (BWTSModel)mapper.readValue(contents, BWTSModel.class);
        return bwtsModel;
    }

    public static BWTSModel getModelFrom(InputStream inputStream) throws JsonParseException, JsonMappingException, IOException {
        String contents = YMLBWTSFileReader.getContentsFrom(inputStream);
        YAMLMapper mapper = new YAMLMapper();
        BWTSModel bwtsModel = (BWTSModel)mapper.readValue(contents, BWTSModel.class);
        return bwtsModel;
    }

    private static String contentsOf(Path filePath) throws IOException {
        File file = filePath.toFile();
        FileInputStream inputStream = new FileInputStream(file);
        String contents = YMLBWTSFileReader.getContentsFrom(inputStream);
        ((InputStream)inputStream).close();
        return contents;
    }

    private static String getContentsFrom(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream);
        Scanner s = scanner.useDelimiter("\\A");
        String contents = s.hasNext() ? s.next() : "";
        s.close();
        scanner.close();
        return contents;
    }
}

