/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.config;

import com.google.common.collect.Maps;
import com.tngtech.jgiven.config.FormatterConfiguration;
import com.tngtech.jgiven.config.TagConfiguration;
import com.tngtech.jgiven.format.Formatter;
import com.tngtech.jgiven.impl.format.FormatterCache;
import java.lang.annotation.Annotation;
import java.util.Map;

public abstract class AbstractJGivenConfiguration
implements FormatterConfiguration {
    private final Map<Class<? extends Annotation>, TagConfiguration> tagConfigurations = Maps.newHashMap();
    private final FormatterCache formatterCache = new FormatterCache();
    private String testClassSuffixRegEx = "Tests?";

    public final TagConfiguration.Builder configureTag(Class<? extends Annotation> tagAnnotation) {
        TagConfiguration configuration = new TagConfiguration(tagAnnotation);
        this.tagConfigurations.put(tagAnnotation, configuration);
        return new TagConfiguration.Builder(configuration);
    }

    public abstract void configure();

    public TagConfiguration getTagConfiguration(Class<? extends Annotation> annotationType) {
        return this.tagConfigurations.get(annotationType);
    }

    public <T> void setFormatter(Class<T> typeToBeFormatted, Formatter<T> formatter) {
        this.formatterCache.setFormatter(typeToBeFormatted, formatter);
    }

    public void setTestClassSuffixRegEx(String suffixRegEx) {
        this.testClassSuffixRegEx = suffixRegEx;
    }

    @Override
    public Formatter<?> getFormatter(Class<?> typeToBeFormatted) {
        return this.formatterCache.getFormatter(typeToBeFormatted);
    }

    public String getTestClassSuffixRegEx() {
        return this.testClassSuffixRegEx;
    }
}

