/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.format;

import com.tngtech.jgiven.exception.JGivenWrongUsageException;
import com.tngtech.jgiven.format.ArgumentFormatter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class DateFormatter
implements ArgumentFormatter<Date> {
    @Override
    public String format(Date date, String ... args) {
        SimpleDateFormat sdf;
        if (date == null) {
            return "";
        }
        if (args.length == 0) {
            throw new JGivenWrongUsageException(String.format("A SimpleDateFormat pattern is expected as first argument", new Object[0]));
        }
        String pattern = args[0];
        Locale locale = Locale.getDefault();
        if (args.length > 1) {
            locale = new Locale(args[1]);
        }
        try {
            sdf = new SimpleDateFormat(pattern, locale);
        }
        catch (IllegalArgumentException e) {
            throw new JGivenWrongUsageException(String.format("A valid SimpleDateFormat pattern is expected (was '%s')", pattern));
        }
        return sdf.format(date);
    }
}

