/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.format;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.NamedFormat;
import com.tngtech.jgiven.annotation.NamedFormats;
import com.tngtech.jgiven.annotation.POJOFormat;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.format.AnnotationArgumentFormatter;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.impl.format.ParameterFormattingUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class POJOAnnotationFormatter
implements AnnotationArgumentFormatter<POJOFormat> {
    private ParameterFormattingUtil pfu = new ParameterFormattingUtil(new DefaultConfiguration());

    @Override
    public String format(Object obj, POJOFormat annotation) {
        if (obj == null) {
            return "null";
        }
        List<Field> fields = this.getFields(obj.getClass(), annotation);
        boolean[] nonNullColumns = new boolean[fields.size()];
        Map<String, ObjectFormatter<?>> formattersByFieldName = this.retrieveFieldsFormatters(annotation, fields);
        StringBuffer sb = new StringBuffer();
        POJOFormat.BracketsEnum brackets = annotation.brackets();
        sb.append(brackets.getOpening());
        String sep = "";
        List<String> values = this.formatRow(obj, fields, formattersByFieldName, nonNullColumns);
        List<String> headers = POJOAnnotationFormatter.getFieldNames(fields);
        for (int i = 0; i < values.size(); ++i) {
            if (!nonNullColumns[i] && (nonNullColumns[i] || !annotation.includeNullColumns())) continue;
            sb.append(sep);
            if (annotation.prefixWithFieldName()) {
                sb.append(headers.get(i));
                sb.append("=");
            }
            sb.append(values.get(i));
            sep = annotation.fieldSeparator();
        }
        sb.append(brackets.getClosing());
        return sb.toString();
    }

    private List<String> formatRow(Object object, List<Field> fields, Map<String, ObjectFormatter<?>> formattersByFieldNames, boolean[] nonNullColumns) {
        List<Object> allFieldValues = ReflectionUtil.getAllFieldValues(object, fields, "");
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < allFieldValues.size(); ++i) {
            Object v = allFieldValues.get(i);
            Field field = fields.get(i);
            if (v != null) {
                nonNullColumns[i] = true;
                DefaultFormatter formatter = formattersByFieldNames.get(field.getName());
                if (formatter != null) {
                    res.add(formatter.format(v));
                    continue;
                }
                formatter = DefaultFormatter.INSTANCE;
                res.add(formatter.format(v));
                continue;
            }
            nonNullColumns[i] = false;
            res.add(null);
        }
        return res;
    }

    private Map<String, ObjectFormatter<?>> retrieveFieldsFormatters(POJOFormat annotation, List<Field> fields) {
        Class<? extends Annotation> aclazz;
        HashMap inter = Maps.newHashMap();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            ObjectFormatter<?> formatter = this.pfu.getFormatting(field.getType(), field.getName(), field.getAnnotations());
            if (formatter == null) continue;
            inter.put(field.getName(), formatter);
        }
        NamedFormat[] nftab = annotation.fieldFormats();
        if (nftab.length == 0 && (aclazz = annotation.fieldFormatsAnnotation()).isAnnotationPresent(NamedFormats.class)) {
            NamedFormats nfset = aclazz.getAnnotation(NamedFormats.class);
            nftab = nfset.value();
        }
        for (NamedFormat nf : nftab) {
            Class<? extends Annotation> cfa = nf.formatAnnotation();
            ObjectFormatter<?> formatter = cfa.equals(Annotation.class) ? this.pfu.getFormatting(Object.class, nf.name(), new Annotation[]{nf.format()}) : this.pfu.getFormatting(Object.class, nf.name(), cfa.getAnnotations());
            inter.put(nf.name(), formatter);
        }
        return inter;
    }

    private List<Field> getFields(Class<?> type, POJOFormat annotation) {
        final HashSet includeFields = Sets.newHashSet((Object[])annotation.includeFields());
        final HashSet excludeFields = Sets.newHashSet((Object[])annotation.excludeFields());
        return FluentIterable.from(ReflectionUtil.getAllNonStaticFields(type)).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                String name = input.getName();
                if (!includeFields.isEmpty()) {
                    return includeFields.contains(name);
                }
                return !excludeFields.contains(name);
            }
        }).toList();
    }

    private static List<String> getFieldNames(Iterable<Field> fields) {
        return FluentIterable.from(ReflectionUtil.getAllFieldNames(fields)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.replace('_', ' ');
            }
        }).toList();
    }
}

