/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.format.table;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.annotation.NamedFormat;
import com.tngtech.jgiven.annotation.NamedFormats;
import com.tngtech.jgiven.annotation.Table;
import com.tngtech.jgiven.config.DefaultConfiguration;
import com.tngtech.jgiven.config.FormatterConfiguration;
import com.tngtech.jgiven.format.DefaultFormatter;
import com.tngtech.jgiven.format.ObjectFormatter;
import com.tngtech.jgiven.format.table.RowFormatter;
import com.tngtech.jgiven.format.table.RowFormatterFactory;
import com.tngtech.jgiven.impl.format.ParameterFormattingUtil;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FieldBasedRowFormatter
extends RowFormatter {
    private ParameterFormattingUtil pfu = new ParameterFormattingUtil(new DefaultConfiguration());
    private final Table tableAnnotation;
    private List<Field> fields;
    boolean[] nonNullColumns;
    Map<String, ObjectFormatter<?>> formattersByFieldName;

    public FieldBasedRowFormatter(Class<?> type, String parameterName, Table tableAnnotation, Annotation[] annotations) {
        this.tableAnnotation = tableAnnotation;
        this.fields = FieldBasedRowFormatter.getFields(tableAnnotation, type);
        this.nonNullColumns = new boolean[this.fields.size()];
        this.formattersByFieldName = this.retrieveFieldsFormatters(tableAnnotation, this.fields);
    }

    @Override
    public List<String> header() {
        return FieldBasedRowFormatter.getFieldNames(this.fields);
    }

    @Override
    public List<String> formatRow(Object object) {
        List<Object> allFieldValues = ReflectionUtil.getAllFieldValues(object, this.fields, "");
        ArrayList res = Lists.newArrayList();
        for (int i = 0; i < allFieldValues.size(); ++i) {
            DefaultFormatter formatter;
            Object v = allFieldValues.get(i);
            Field field = this.fields.get(i);
            if (v != null) {
                this.nonNullColumns[i] = true;
            }
            if ((formatter = this.formattersByFieldName.get(field.getName())) != null) {
                res.add(formatter.format(v));
                continue;
            }
            formatter = DefaultFormatter.INSTANCE;
            res.add(formatter.format(v));
        }
        return res;
    }

    private Map<String, ObjectFormatter<?>> retrieveFieldsFormatters(Table annotation, List<Field> fields) {
        Class<? extends Annotation> aclazz;
        HashMap inter = Maps.newHashMap();
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            ObjectFormatter<?> formatter = this.pfu.getFormatting(field.getType(), field.getName(), field.getAnnotations());
            if (formatter == null) continue;
            inter.put(field.getName(), formatter);
        }
        NamedFormat[] nftab = annotation.fieldsFormat();
        if (nftab.length == 0 && (aclazz = annotation.fieldsFormatSetAnnotation()).isAnnotationPresent(NamedFormats.class)) {
            NamedFormats nfset = aclazz.getAnnotation(NamedFormats.class);
            nftab = nfset.value();
        }
        for (NamedFormat nf : nftab) {
            Class<? extends Annotation> cfa = nf.formatAnnotation();
            ObjectFormatter<?> formatter = cfa.equals(Annotation.class) ? this.pfu.getFormatting(Object.class, nf.name(), new Annotation[]{nf.format()}) : this.pfu.getFormatting(Object.class, nf.name(), cfa.getAnnotations());
            inter.put(nf.name(), formatter);
        }
        return inter;
    }

    private static List<Field> getFields(Table tableAnnotation, Class<?> type) {
        final HashSet includeFields = Sets.newHashSet((Object[])tableAnnotation.includeFields());
        final HashSet excludeFields = Sets.newHashSet((Object[])tableAnnotation.excludeFields());
        return FluentIterable.from(ReflectionUtil.getAllNonStaticFields(type)).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field input) {
                String name = input.getName();
                if (!includeFields.isEmpty()) {
                    return includeFields.contains(name);
                }
                return !excludeFields.contains(name);
            }
        }).toList();
    }

    private static List<String> getFieldNames(Iterable<Field> fields) {
        return FluentIterable.from(ReflectionUtil.getAllFieldNames(fields)).transform((Function)new Function<String, String>(){

            public String apply(String input) {
                return input.replace('_', ' ');
            }
        }).toList();
    }

    @Override
    public List<List<String>> postProcess(List<List<String>> list) {
        if (!this.tableAnnotation.includeNullColumns()) {
            return this.removeNullColumns(list);
        }
        return list;
    }

    private List<List<String>> removeNullColumns(List<List<String>> list) {
        ArrayList newList = Lists.newArrayListWithCapacity((int)list.size());
        for (List<String> row : list) {
            ArrayList newRow = Lists.newArrayList();
            newList.add(newRow);
            for (int i = 0; i < this.nonNullColumns.length; ++i) {
                if (!this.nonNullColumns[i]) continue;
                newRow.add(row.get(i));
            }
        }
        return newList;
    }

    public static class Factory
    implements RowFormatterFactory {
        @Override
        public RowFormatter create(Class<?> parameterType, String parameterName, Table tableAnnotation, Annotation[] annotations, FormatterConfiguration configuration, ObjectFormatter<?> objectFormatter) {
            return new FieldBasedRowFormatter(parameterType, parameterName, tableAnnotation, annotations);
        }
    }
}

