/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.tngtech.jgiven.impl.ScenarioExecutor;
import com.tngtech.jgiven.impl.ScenarioModelBuilder;
import com.tngtech.jgiven.impl.StageClassCreator;
import com.tngtech.jgiven.impl.StageCreator;
import com.tngtech.jgiven.impl.util.AssertionUtil;
import com.tngtech.jgiven.integration.CanWire;
import com.tngtech.jgiven.report.model.NamedArgument;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import java.lang.reflect.Method;
import java.util.List;

public class ScenarioBase {
    protected ScenarioExecutor executor = new ScenarioExecutor();
    protected final ScenarioModelBuilder modelBuilder = new ScenarioModelBuilder();
    private boolean initialized = false;

    public void setModel(ReportModel reportModel) {
        this.assertNotInitialized();
        this.modelBuilder.setReportModel(reportModel);
    }

    public ScenarioModel getScenarioModel() {
        return this.modelBuilder.getScenarioModel();
    }

    public ScenarioCaseModel getScenarioCaseModel() {
        return this.modelBuilder.getScenarioCaseModel();
    }

    public ReportModel getModel() {
        return this.modelBuilder.getReportModel();
    }

    public <T> T addStage(Class<T> stepsClass) {
        return this.executor.addStage(stepsClass);
    }

    public void finished() throws Throwable {
        this.executor.finished();
    }

    public ScenarioExecutor getExecutor() {
        return this.executor;
    }

    public void setExecutor(ScenarioExecutor executor) {
        this.assertNotInitialized();
        this.executor = executor;
    }

    public void wireSteps(CanWire canWire) {
        this.executor.wireSteps(canWire);
    }

    public ScenarioBase startScenario(Class<?> testClass, Method method, List<NamedArgument> arguments) {
        this.performInitialization();
        this.executor.startScenario(testClass, method, arguments);
        return this;
    }

    public ScenarioBase startScenario(String description) {
        this.performInitialization();
        this.executor.startScenario(description);
        return this;
    }

    private void performInitialization() {
        if (this.modelBuilder == null) {
            throw new IllegalStateException("modelBuilder must be set before Scenario can be initalized.");
        }
        if (!this.initialized) {
            this.executor.setListener(this.modelBuilder);
            this.initialize();
            this.initialized = true;
        }
    }

    protected void initialize() {
    }

    protected void assertNotInitialized() {
        AssertionUtil.assertTrue(!this.initialized, "Scenario is already initialized");
    }

    public void section(String sectionTitle) {
        this.executor.addSection(sectionTitle);
    }

    public void setStageCreator(StageCreator stageCreator) {
        this.executor.setStageCreator(stageCreator);
    }

    public void setStageClassCreator(StageClassCreator stageClassCreator) {
        this.executor.setStageClassCreator(stageClassCreator);
    }
}

