/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.tngtech.jgiven.report.model.DataTable;
import com.tngtech.jgiven.report.text.PlainTextWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class PlainTextTableWriter
extends PlainTextWriter {
    public PlainTextTableWriter(PrintWriter printWriter, boolean withColor) {
        super(printWriter, withColor);
    }

    public void writeDataTable(DataTable dataTable, String indent) {
        if (dataTable.getData().isEmpty()) {
            return;
        }
        StringBuilder formatBuilder = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        List<List<String>> tableModel = PlainTextTableWriter.handleNewLines(dataTable.getData());
        List<ColumnSpec> columnWidths = this.getColumnSpecs(tableModel);
        for (ColumnSpec spec : columnWidths) {
            formatBuilder.append("| %");
            if (spec.leftAligned) {
                formatBuilder.append("-");
            }
            formatBuilder.append(spec.width + "s ");
            lineBuilder.append("+");
            lineBuilder.append(Strings.repeat((String)"-", (int)(spec.width + 2)));
        }
        formatBuilder.append("|");
        lineBuilder.append("+");
        String formatString = formatBuilder.toString();
        this.writer.println(indent + String.format(formatString, tableModel.get(0).toArray()));
        if (dataTable.getHeaderType().isHorizontal()) {
            this.writer.println(indent + lineBuilder);
        }
        for (int nrow = 1; nrow < tableModel.size(); ++nrow) {
            this.writer.println(indent + String.format(formatString, tableModel.get(nrow).toArray()));
        }
    }

    static List<List<String>> handleNewLines(List<List<String>> tableModel) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)tableModel.size());
        for (List<String> row : tableModel) {
            if (PlainTextTableWriter.hasNewline(row)) {
                result.addAll(PlainTextTableWriter.splitRow(row));
                continue;
            }
            result.add(row);
        }
        return result;
    }

    private static Collection<List<String>> splitRow(List<String> row) {
        ArrayList columns = Lists.newArrayListWithExpectedSize((int)row.size());
        int nRows = 0;
        for (String cell : row) {
            ImmutableList lines = FluentIterable.from((Iterable)Splitter.onPattern((String)"\\r?\\n").split((CharSequence)cell)).toList();
            if (lines.size() > nRows) {
                nRows = lines.size();
            }
            columns.add(lines);
        }
        ArrayList rows = Lists.newArrayListWithCapacity((int)nRows);
        for (int iRow = 0; iRow < nRows; ++iRow) {
            ArrayList newRow = Lists.newArrayListWithExpectedSize((int)row.size());
            for (int iCol = 0; iCol < columns.size(); ++iCol) {
                List column = (List)columns.get(iCol);
                String cell = "";
                if (iRow < column.size()) {
                    cell = (String)column.get(iRow);
                }
                newRow.add(cell);
            }
            rows.add(newRow);
        }
        return rows;
    }

    private static boolean hasNewline(List<String> row) {
        for (String cell : row) {
            if (cell == null || !cell.contains("\n")) continue;
            return true;
        }
        return false;
    }

    private List<ColumnSpec> getColumnSpecs(List<List<String>> dataTableModel) {
        if (dataTableModel.isEmpty()) {
            return Collections.emptyList();
        }
        Object[] result = new ColumnSpec[dataTableModel.get(0).size()];
        for (int nrow = 0; nrow < dataTableModel.size(); ++nrow) {
            List<String> row = dataTableModel.get(nrow);
            for (int ncol = 0; ncol < row.size(); ++ncol) {
                String value = row.get(ncol);
                int width = Math.max(value.length(), 1);
                Object spec = result[ncol];
                if (spec == null) {
                    result[ncol] = spec = new ColumnSpec();
                }
                if (width > ((ColumnSpec)spec).width) {
                    ((ColumnSpec)spec).width = width;
                }
                if (nrow <= 0 || Doubles.tryParse((String)value) != null) continue;
                ((ColumnSpec)spec).leftAligned = true;
            }
        }
        return Lists.newArrayList((Object[])result);
    }

    static class ColumnSpec {
        int width;
        boolean leftAligned;

        ColumnSpec() {
        }
    }
}

