/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.tngtech.jgiven.impl.ScenarioBase;

public class Scenario<GIVEN, WHEN, THEN>
extends ScenarioBase {
    private final GIVEN givenStage;
    private final WHEN whenStage;
    private final THEN thenStage;

    private Scenario(Class<?> stageClass) {
        this.givenStage = this.executor.addStage(stageClass);
        this.whenStage = this.givenStage;
        this.thenStage = this.givenStage;
    }

    public Scenario(Class<GIVEN> givenClass, Class<WHEN> whenClass, Class<THEN> thenClass) {
        this.givenStage = this.executor.addStage(givenClass);
        this.whenStage = this.executor.addStage(whenClass);
        this.thenStage = this.executor.addStage(thenClass);
    }

    public GIVEN getGivenStage() {
        return this.givenStage;
    }

    public WHEN getWhenStage() {
        return this.whenStage;
    }

    public THEN getThenStage() {
        return this.thenStage;
    }

    public void addIntroWord(String word) {
        this.executor.addIntroWord(word);
    }

    public static <GIVEN, WHEN, THEN> Scenario<GIVEN, WHEN, THEN> create(Class<GIVEN> givenClass, Class<WHEN> whenClass, Class<THEN> thenClass) {
        return new Scenario<GIVEN, WHEN, THEN>(givenClass, whenClass, thenClass);
    }

    public static <STEPS> Scenario<STEPS, STEPS, STEPS> create(Class<STEPS> stepsClass) {
        return new Scenario(stepsClass);
    }

    @Override
    public Scenario<GIVEN, WHEN, THEN> startScenario(String description) {
        super.startScenario(description);
        return this;
    }

    public Scenario<GIVEN, WHEN, THEN> as(String description) {
        return this.startScenario(description);
    }

    public GIVEN given() {
        return this.given("Given");
    }

    public WHEN when() {
        return this.when("When");
    }

    public THEN then() {
        return this.then("Then");
    }

    public GIVEN given(String translatedGiven) {
        this.addIntroWord(translatedGiven);
        return this.getGivenStage();
    }

    public WHEN when(String translatedGiven) {
        this.addIntroWord(translatedGiven);
        return this.getWhenStage();
    }

    public THEN then(String translatedGiven) {
        this.addIntroWord(translatedGiven);
        return this.getThenStage();
    }
}

