/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.tngtech.jgiven.annotation.AfterScenario;
import com.tngtech.jgiven.annotation.AfterStage;
import com.tngtech.jgiven.annotation.BeforeScenario;
import com.tngtech.jgiven.annotation.BeforeStage;
import com.tngtech.jgiven.annotation.Hidden;
import com.tngtech.jgiven.annotation.IntroWord;
import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.annotation.ScenarioRule;
import com.tngtech.jgiven.annotation.ScenarioStage;
import com.tngtech.jgiven.exception.FailIfPassedException;
import com.tngtech.jgiven.exception.JGivenUserException;
import com.tngtech.jgiven.impl.inject.ValueInjector;
import com.tngtech.jgiven.impl.intercept.InvocationMode;
import com.tngtech.jgiven.impl.intercept.NoOpScenarioListener;
import com.tngtech.jgiven.impl.intercept.ScenarioListener;
import com.tngtech.jgiven.impl.intercept.StepMethodHandler;
import com.tngtech.jgiven.impl.intercept.StepMethodInterceptor;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import com.tngtech.jgiven.impl.util.ScenarioUtil;
import com.tngtech.jgiven.integration.CanWire;
import com.tngtech.jgiven.report.model.NamedArgument;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScenarioExecutor {
    private static final Logger log = LoggerFactory.getLogger(ScenarioExecutor.class);
    private Object currentStage;
    private State state = State.INIT;
    private boolean beforeStepsWereExecuted;
    private final AtomicInteger stackDepth = new AtomicInteger();
    private final Map<Class<?>, StageState> stages = Maps.newLinkedHashMap();
    private final List<Object> scenarioRules = Lists.newArrayList();
    private final ValueInjector injector = new ValueInjector();
    private ScenarioListener listener = new NoOpScenarioListener();
    private final StepMethodHandler methodHandler = new MethodHandler();
    private final StepMethodInterceptor methodInterceptor = new StepMethodInterceptor(this.methodHandler, this.stackDepth);
    private Throwable failedException;
    private boolean failIfPass;
    private boolean suppressExceptions;

    public ScenarioExecutor() {
        this.injector.injectValueByType(ScenarioExecutor.class, this);
    }

    public <T> T addStage(Class<T> stepsClass) {
        if (this.stages.containsKey(stepsClass)) {
            return (T)this.stages.get(stepsClass).instance;
        }
        T result = this.setupCglibProxy(stepsClass);
        this.stages.put(stepsClass, new StageState(result));
        this.gatherRules(result);
        this.injectSteps(result);
        return result;
    }

    private <T> T setupCglibProxy(Class<T> stepsClass) {
        Enhancer e = new Enhancer();
        e.setSuperclass(stepsClass);
        e.setCallback((Callback)this.methodInterceptor);
        Object result = e.create();
        this.methodInterceptor.enableMethodHandling(true);
        return (T)result;
    }

    public void addIntroWord(String word) {
        this.listener.introWordAdded(word);
    }

    private void gatherRules(Object stage) {
        ReflectionUtil.forEachField(stage, stage.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioRule.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                log.debug("Found rule in field: " + field);
                field.setAccessible(true);
                ScenarioExecutor.this.scenarioRules.add(field.get(object));
            }
        });
    }

    private <T> T update(T t) throws Throwable {
        if (this.currentStage == t) {
            return t;
        }
        if (this.currentStage == null) {
            this.ensureBeforeStepsAreExecuted();
        } else {
            this.executeAfterStageMethods(this.currentStage);
            this.readScenarioState(this.currentStage);
        }
        this.injector.updateValues(t);
        StageState stageState = this.getStageState(t);
        if (!stageState.beforeStageCalled) {
            stageState.beforeStageCalled = true;
            this.executeBeforeStageSteps(t);
        }
        this.currentStage = t;
        return t;
    }

    private void executeAfterStageMethods(Object stage) throws Throwable {
        StageState stageState = this.getStageState(stage);
        if (stageState.afterStageCalled) {
            return;
        }
        this.methodInterceptor.enableMethodHandling(false);
        stageState.afterStageCalled = true;
        this.executeAnnotatedMethods(stage, AfterStage.class);
        this.methodInterceptor.enableMethodHandling(true);
    }

    StageState getStageState(Object stage) {
        return this.stages.get(stage.getClass().getSuperclass());
    }

    private void ensureBeforeStepsAreExecuted() throws Throwable {
        if (this.state != State.INIT) {
            return;
        }
        this.state = State.STARTED;
        this.methodInterceptor.enableMethodHandling(false);
        try {
            for (Object rule : this.scenarioRules) {
                this.invokeRuleMethod(rule, "before");
            }
            this.beforeStepsWereExecuted = true;
            for (StageState stage : this.stages.values()) {
                this.executeBeforeScenarioSteps(stage.instance);
            }
        }
        catch (Throwable e) {
            this.failed(e);
            this.finished();
            throw e;
        }
        this.methodInterceptor.enableMethodHandling(true);
    }

    private void executeAnnotatedMethods(Object stage, final Class<? extends Annotation> annotationClass) throws Throwable {
        log.debug("Executing methods annotated with @{}", (Object)annotationClass.getName());
        try {
            this.methodInterceptor.enableMethodHandling(false);
            ReflectionUtil.forEachMethod(stage, stage.getClass(), annotationClass, new ReflectionUtil.MethodAction(){

                @Override
                public void act(Object object, Method method) throws Exception {
                    ReflectionUtil.invokeMethod(object, method, " with annotation @" + annotationClass.getName());
                }
            });
            this.methodInterceptor.enableMethodHandling(true);
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
    }

    private void invokeRuleMethod(Object rule, String methodName) throws Throwable {
        Optional<Method> optionalMethod = ReflectionUtil.findMethodTransitively(rule.getClass(), methodName);
        if (!optionalMethod.isPresent()) {
            log.debug("Class {} has no {} method, but was used as ScenarioRule!", rule.getClass(), (Object)methodName);
            return;
        }
        try {
            ReflectionUtil.invokeMethod(rule, (Method)optionalMethod.get(), " of rule class " + rule.getClass().getName());
        }
        catch (JGivenUserException e) {
            throw e.getCause();
        }
    }

    void executeBeforeStageSteps(Object stage) throws Throwable {
        this.executeAnnotatedMethods(stage, BeforeStage.class);
    }

    private void executeBeforeScenarioSteps(Object stage) throws Throwable {
        this.executeAnnotatedMethods(stage, BeforeScenario.class);
    }

    public void readScenarioState(Object object) {
        this.injector.readValues(object);
    }

    public void wireSteps(CanWire canWire) {
        for (StageState steps : this.stages.values()) {
            canWire.wire(steps.instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() throws Throwable {
        if (this.state == State.FINISHED) {
            return;
        }
        if (this.state != State.STARTED) {
            throw new IllegalStateException("The Scenario must be in state STARTED in order to finish it, but it is in state " + (Object)((Object)this.state));
        }
        this.state = State.FINISHED;
        this.methodInterceptor.enableMethodHandling(false);
        try {
            this.callFinishLifeCycleMethods();
        }
        finally {
            this.listener.scenarioFinished();
        }
    }

    private void callFinishLifeCycleMethods() throws Throwable {
        Throwable firstThrownException = this.failedException;
        if (this.beforeStepsWereExecuted) {
            if (this.currentStage != null) {
                try {
                    this.executeAfterStageMethods(this.currentStage);
                }
                catch (AssertionError e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
                }
                catch (Exception e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, e);
                }
            }
            for (StageState stage : Lists.reverse((List)Lists.newArrayList(this.stages.values()))) {
                try {
                    this.executeAnnotatedMethods(stage.instance, AfterScenario.class);
                }
                catch (AssertionError e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
                }
                catch (Exception e) {
                    firstThrownException = this.logAndGetFirstException(firstThrownException, e);
                }
            }
        }
        for (Object rule : Lists.reverse(this.scenarioRules)) {
            try {
                this.invokeRuleMethod(rule, "after");
            }
            catch (AssertionError e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, (Throwable)((Object)e));
            }
            catch (Exception e) {
                firstThrownException = this.logAndGetFirstException(firstThrownException, e);
            }
        }
        this.failedException = firstThrownException;
        if (!this.suppressExceptions && this.failedException != null) {
            throw this.failedException;
        }
        if (this.failIfPass && this.failedException == null) {
            throw new FailIfPassedException();
        }
    }

    private Throwable logAndGetFirstException(Throwable firstThrownException, Throwable newException) {
        log.error(newException.getMessage(), newException);
        return firstThrownException == null ? newException : firstThrownException;
    }

    public void injectSteps(Object stage) {
        ReflectionUtil.forEachField(stage, stage.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioStage.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                Object steps = ScenarioExecutor.this.addStage(field.getType());
                ReflectionUtil.setField(field, object, steps, ", annoted with @ScenarioStage");
            }
        });
    }

    public void failed(Throwable e) {
        this.listener.scenarioFailed(e);
        this.methodInterceptor.disableMethodExecution();
        this.failedException = e;
    }

    public void startScenario(String description) {
        this.listener.scenarioStarted(description);
    }

    public void startScenario(Method method, List<NamedArgument> arguments) {
        this.listener.scenarioStarted(method, arguments);
        if (method.isAnnotationPresent(NotImplementedYet.class)) {
            NotImplementedYet annotation = method.getAnnotation(NotImplementedYet.class);
            if (annotation.failIfPass()) {
                this.failIfPass();
            } else if (!annotation.executeSteps()) {
                this.methodInterceptor.disableMethodExecution();
            }
            this.suppressExceptions = true;
        }
    }

    public void setListener(ScenarioListener listener) {
        this.listener = listener;
    }

    public void failIfPass() {
        this.failIfPass = true;
    }

    class MethodHandler
    implements StepMethodHandler {
        MethodHandler() {
        }

        @Override
        public void handleMethod(Object stageInstance, Method paramMethod, Object[] arguments, InvocationMode mode) throws Throwable {
            if (paramMethod.isSynthetic()) {
                return;
            }
            if (paramMethod.isAnnotationPresent(AfterStage.class) || paramMethod.isAnnotationPresent(BeforeStage.class) || paramMethod.isAnnotationPresent(BeforeScenario.class) || paramMethod.isAnnotationPresent(AfterScenario.class) || paramMethod.isAnnotationPresent(Hidden.class)) {
                return;
            }
            ScenarioExecutor.this.update(stageInstance);
            if (paramMethod.isAnnotationPresent(IntroWord.class)) {
                ScenarioExecutor.this.listener.introWordAdded(paramMethod.getName());
            } else {
                List<NamedArgument> namedArguments = ScenarioUtil.mapArgumentsWithParameterNames(paramMethod, Arrays.asList(arguments));
                ScenarioExecutor.this.listener.stepMethodInvoked(paramMethod, namedArguments, mode);
            }
        }

        @Override
        public void handleThrowable(Throwable t) throws Throwable {
            ScenarioExecutor.this.listener.stepMethodFailed(t);
            ScenarioExecutor.this.failed(t);
        }

        @Override
        public void handleMethodFinished(long durationInNanos) {
            ScenarioExecutor.this.listener.stepMethodFinished(durationInNanos);
        }
    }

    static class StageState {
        final Object instance;
        boolean afterStageCalled;
        boolean beforeStageCalled;

        StageState(Object instance) {
            this.instance = instance;
        }
    }

    public static enum State {
        INIT,
        STARTED,
        FINISHED;

    }
}

