/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.inject;

import com.google.common.collect.Maps;
import com.tngtech.jgiven.annotation.ExpectedScenarioState;
import com.tngtech.jgiven.annotation.ProvidedScenarioState;
import com.tngtech.jgiven.annotation.ScenarioState;
import com.tngtech.jgiven.exception.AmbiguousResolutionException;
import com.tngtech.jgiven.impl.inject.ValueInjectorState;
import com.tngtech.jgiven.impl.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueInjector {
    private static final Logger log = LoggerFactory.getLogger(ValueInjector.class);
    private final ValueInjectorState state = new ValueInjectorState();

    public void validateFields(Object object) {
        final HashMap resolvedFields = Maps.newHashMap();
        ReflectionUtil.forEachField(object, object.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioState.class, ProvidedScenarioState.class, ExpectedScenarioState.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                field.setAccessible(true);
                ScenarioState.Resolution resolution = ValueInjector.this.getResolution(field);
                Object key = null;
                key = resolution == ScenarioState.Resolution.NAME ? field.getName() : field.getType();
                if (resolvedFields.containsKey(key)) {
                    Field existingField = (Field)resolvedFields.get(key);
                    throw new AmbiguousResolutionException("Ambiguous fields with same " + (Object)((Object)resolution) + " detected. Field 1: " + existingField + ", field 2: " + field);
                }
                resolvedFields.put(key, field);
            }
        });
    }

    public void readValues(Object object) {
        this.validateFields(object);
        ReflectionUtil.forEachField(object, object.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioState.class, ExpectedScenarioState.class, ProvidedScenarioState.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                field.setAccessible(true);
                Object value = field.get(object);
                ValueInjector.this.updateValue(field, value);
                log.debug("Reading value " + value + " from field " + field);
            }
        });
    }

    public void updateValues(Object object) {
        this.validateFields(object);
        ReflectionUtil.forEachField(object, object.getClass(), ReflectionUtil.hasAtLeastOneAnnotation(ScenarioState.class, ExpectedScenarioState.class, ProvidedScenarioState.class), new ReflectionUtil.FieldAction(){

            @Override
            public void act(Object object, Field field) throws Exception {
                field.setAccessible(true);
                Object value = ValueInjector.this.getValue(field);
                if (value != null) {
                    field.set(object, value);
                    log.debug("Setting field " + field + " to value " + value);
                }
            }
        });
    }

    public <T> void injectValueByType(Class<T> clazz, T value) {
        this.state.updateValueByType(clazz, value);
    }

    public <T> void injectValueByName(String name, T value) {
        this.state.updateValueByName(name, value);
    }

    private void updateValue(Field field, Object value) {
        ScenarioState.Resolution resolution = this.getResolution(field);
        Class<?> type = field.getType();
        if (resolution == ScenarioState.Resolution.NAME) {
            String name = field.getName();
            this.state.updateValueByName(name, value);
        } else {
            this.state.updateValueByType(type, value);
        }
    }

    private Object getValue(Field field) {
        ScenarioState.Resolution resolution = this.getResolution(field);
        Class<?> type = field.getType();
        if (resolution == ScenarioState.Resolution.NAME) {
            String name = field.getName();
            return this.state.getValueByName(name);
        }
        return this.state.getValueByType(type);
    }

    private ScenarioState.Resolution getResolution(Field field) {
        ScenarioState.Resolution resolution = this.getDeclaredResolution(field);
        if (resolution == ScenarioState.Resolution.AUTO) {
            return this.typeIsTooGeneric(field.getType()) ? ScenarioState.Resolution.NAME : ScenarioState.Resolution.TYPE;
        }
        return resolution;
    }

    private ScenarioState.Resolution getDeclaredResolution(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (annotation instanceof ScenarioState) {
                return ((ScenarioState)annotation).resolution();
            }
            if (annotation instanceof ProvidedScenarioState) {
                return ((ProvidedScenarioState)annotation).resolution();
            }
            if (!(annotation instanceof ExpectedScenarioState)) continue;
            return ((ExpectedScenarioState)annotation).resolution();
        }
        throw new IllegalArgumentException("Field " + field + " has no valid annotation");
    }

    private boolean typeIsTooGeneric(Class<?> type) {
        return type.isPrimitive() || type.getName().startsWith("java.lang") || type.getName().startsWith("java.io") || type.getName().startsWith("java.util");
    }
}

