/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.intercept;

import com.tngtech.jgiven.annotation.NotImplementedYet;
import com.tngtech.jgiven.impl.intercept.InvocationMode;
import com.tngtech.jgiven.impl.intercept.StepMethodHandler;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StepMethodInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(StepMethodInterceptor.class);
    private final StepMethodHandler scenarioMethodHandler;
    private final AtomicInteger stackDepth;
    private boolean methodHandlingEnabled;
    private boolean methodExecutionEnabled = true;

    public StepMethodInterceptor(StepMethodHandler scenarioMethodHandler, AtomicInteger stackDepth) {
        this.scenarioMethodHandler = scenarioMethodHandler;
        this.stackDepth = stackDepth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Object receiver, Method method, Object[] parameters, MethodProxy methodProxy) throws Throwable {
        boolean handleMethod;
        long started = System.nanoTime();
        InvocationMode mode = this.getInvocationMode(receiver, method);
        boolean bl = handleMethod = this.methodHandlingEnabled && this.stackDepth.get() == 0 && !method.getDeclaringClass().equals(Object.class);
        if (handleMethod) {
            this.scenarioMethodHandler.handleMethod(receiver, method, parameters, mode);
        }
        if (mode == InvocationMode.SKIPPED || mode == InvocationMode.NOT_IMPLEMENTED_YET) {
            return this.returnReceiverOrNull(receiver, method);
        }
        try {
            this.stackDepth.incrementAndGet();
            Object object = methodProxy.invokeSuper(receiver, parameters);
            return object;
        }
        catch (Exception t) {
            Object object = this.handleThrowable(receiver, method, t, System.nanoTime() - started);
            return object;
        }
        catch (AssertionError e) {
            Object object = this.handleThrowable(receiver, method, (Throwable)((Object)e), System.nanoTime() - started);
            return object;
        }
        finally {
            this.stackDepth.decrementAndGet();
            if (handleMethod) {
                this.scenarioMethodHandler.handleMethodFinished(System.nanoTime() - started);
            }
        }
    }

    private Object handleThrowable(Object receiver, Method method, Throwable t, long durationInNanos) throws Throwable {
        if (this.methodHandlingEnabled) {
            this.scenarioMethodHandler.handleThrowable(t);
            return this.returnReceiverOrNull(receiver, method);
        }
        throw t;
    }

    private Object returnReceiverOrNull(Object receiver, Method method) {
        if (!method.getReturnType().isAssignableFrom(receiver.getClass())) {
            log.warn("The step method " + method.getName() + " of class " + method.getDeclaringClass().getSimpleName() + " does not follow the fluent interface convention of returning " + "the receiver object. Please change the return type to the SELF type parameter.");
            return null;
        }
        return receiver;
    }

    private InvocationMode getInvocationMode(Object receiver, Method method) {
        if (!this.methodExecutionEnabled) {
            return InvocationMode.SKIPPED;
        }
        if (method.isAnnotationPresent(NotImplementedYet.class) || receiver.getClass().isAnnotationPresent(NotImplementedYet.class)) {
            return InvocationMode.NOT_IMPLEMENTED_YET;
        }
        return InvocationMode.NORMAL;
    }

    public void enableMethodHandling(boolean b) {
        this.methodHandlingEnabled = b;
    }

    public void disableMethodExecution() {
        this.methodExecutionEnabled = false;
    }
}

