/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.impl.util;

import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.impl.util.ResourceUtil;
import java.io.InputStream;
import java.util.Properties;

public class Version {
    public static final String JGIVEN_VERSION_PROPERTIES = "com/tngtech/jgiven/jgiven-version.properties";
    public static final Version VERSION = Version.loadVersion();
    private final String versionString;
    private final String commitHash;

    public Version(String versionString, String commitHash) {
        this.versionString = versionString;
        this.commitHash = commitHash;
    }

    public String toString() {
        return this.versionString + "-" + this.commitHash;
    }

    private static Version loadVersion() {
        Version version;
        Properties properties = new Properties();
        InputStream resourceAsStream = Version.class.getClassLoader().getResourceAsStream(JGIVEN_VERSION_PROPERTIES);
        try {
            properties.load(resourceAsStream);
            version = Version.fromProperties(properties);
        }
        catch (Exception e) {
            try {
                throw new JGivenInstallationException("Could not load the JGiven version file com/tngtech/jgiven/jgiven-version.properties. " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                ResourceUtil.close(resourceAsStream);
                throw throwable;
            }
        }
        ResourceUtil.close(resourceAsStream);
        return version;
    }

    private static Version fromProperties(Properties properties) {
        String versionString = properties.getProperty("jgiven.version", "Unkown Version");
        String commitHash = properties.getProperty("jgiven.buildNumber", "Unkown Build Number");
        return new Version(versionString, commitHash);
    }
}

