/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report;

import com.google.common.io.Files;
import com.tngtech.jgiven.exception.JGivenInstallationException;
import com.tngtech.jgiven.exception.JGivenInternalDefectException;
import com.tngtech.jgiven.report.html.StaticHtmlReportGenerator;
import com.tngtech.jgiven.report.impl.FileGenerator;
import com.tngtech.jgiven.report.text.PlainTextReportGenerator;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final Logger log = LoggerFactory.getLogger(ReportGenerator.class);
    private File sourceDir = new File(".");
    private File toDir = new File(".");
    private File customCssFile = null;
    private Format format = Format.HTML;

    public static void main(String ... args) throws Exception {
        ReportGenerator generator = new ReportGenerator();
        ReportGenerator.parseArgs(generator, args);
        generator.generate();
    }

    static void parseArgs(ReportGenerator generator, String ... args) {
        for (String arg : args) {
            if (arg.equals("-h") || arg.equals("--help")) {
                ReportGenerator.printUsageAndExit();
                continue;
            }
            if (arg.startsWith("--dir=")) {
                generator.setSourceDir(new File(arg.split("=")[1]));
                continue;
            }
            if (arg.startsWith("--todir=")) {
                generator.setToDir(new File(arg.split("=")[1]));
                continue;
            }
            if (arg.startsWith("--customcss=")) {
                generator.setCustomCssFile(new File(arg.split("=")[1]));
                continue;
            }
            if (arg.startsWith("--format=")) {
                String formatArg = arg.split("=")[1];
                Format format = Format.fromStringOrNull(formatArg);
                if (format == null) {
                    System.err.println("Illegal argument for --format: " + formatArg);
                    ReportGenerator.printUsageAndExit();
                }
                generator.setFormat(format);
                continue;
            }
            ReportGenerator.printUsageAndExit();
        }
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void generate() throws Exception {
        if (!this.getToDir().exists() && !this.getToDir().mkdirs()) {
            log.error("Could not create target directory " + this.getToDir());
            return;
        }
        if (this.format == Format.HTML) {
            this.generateStaticHtmlReport();
        } else if (this.format == Format.HTML5) {
            this.generateHtml5Report();
        } else if (this.format == Format.TEXT) {
            new PlainTextReportGenerator().generate(this.getToDir(), this.getSourceDir());
        }
    }

    private void generateStaticHtmlReport() throws IOException {
        new StaticHtmlReportGenerator().generate(this.getToDir(), this.getSourceDir());
        if (this.getCustomCssFile() != null) {
            if (!this.getCustomCssFile().canRead()) {
                log.info("Cannot read customCssFile " + this.getCustomCssFile() + " skipping");
            } else {
                Files.copy((File)this.getCustomCssFile(), (File)new File(this.getToDir(), "custom.css"));
            }
        }
    }

    private void generateHtml5Report() throws IOException {
        FileGenerator fileGenerator;
        try {
            Class<?> aClass = this.getClass().getClassLoader().loadClass("com.tngtech.jgiven.report.html5.Html5ReportGenerator");
            fileGenerator = (FileGenerator)aClass.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JGivenInstallationException("The JGiven HTML5 Report Generator seems not to be on the classpath.\nEnsure that you have a dependency to jgiven-html5-report.");
        }
        catch (Exception e) {
            throw new JGivenInternalDefectException("The HTML5 Report Generator could not be instantiated.", e);
        }
        fileGenerator.generate(this.getToDir(), this.getSourceDir());
    }

    private static void printUsageAndExit() {
        System.err.println("Options: [--format=<format>] [--dir=<dir>] [--todir=<dir>] [--customcss=<cssfile>]");
        System.err.println("  <format> = html, html5, or text, default is html");
        System.exit(1);
    }

    public File getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(File sourceDir) {
        this.sourceDir = sourceDir;
    }

    public File getToDir() {
        return this.toDir;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public File getCustomCssFile() {
        return this.customCssFile;
    }

    public void setCustomCssFile(File customCssFile) {
        this.customCssFile = customCssFile;
    }

    public static enum Format {
        HTML("html"),
        TEXT("text"),
        HTML5("html5");

        private final String text;

        private Format(String text) {
            this.text = text;
        }

        public static Format fromStringOrNull(String value) {
            for (Format format : Format.values()) {
                if (!format.text.equalsIgnoreCase(value)) continue;
                return format;
            }
            return null;
        }
    }
}

