/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.analysis;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.tngtech.jgiven.report.analysis.CaseDifferenceAnalyzer;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseArgumentAnalyser {
    private static final Logger log = LoggerFactory.getLogger(CaseArgumentAnalyser.class);

    public void analyze(ReportModel model) {
        for (ScenarioModel scenarioModel : model.getScenarios()) {
            this.analyze(scenarioModel);
        }
    }

    public void analyze(ScenarioModel scenarioModel) {
        if (scenarioModel.getScenarioCases().size() < 2) {
            return;
        }
        CollectPhase collectPhase = new CollectPhase(scenarioModel);
        scenarioModel.accept(collectPhase);
        try {
            this.reduceMatrix(scenarioModel, collectPhase.argumentMatrix);
            scenarioModel.setCasesAsTable(this.allStepsEqual(collectPhase.allWords));
            if (!scenarioModel.isCasesAsTable()) {
                new CaseDifferenceAnalyzer().analyze(scenarioModel);
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.info("Scenario model " + scenarioModel.className + "." + scenarioModel.testMethodName + " has no homogene cases." + " Cannot analyse argument cases");
            scenarioModel.setCasesAsTable(false);
        }
    }

    private boolean allStepsEqual(List<List<Word>> allWords) {
        List<Word> firstWords = allWords.get(0);
        for (int i = 1; i < allWords.size(); ++i) {
            if (this.wordsAreEqual(firstWords, allWords.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean wordsAreEqual(List<Word> firstWords, List<Word> words) {
        if (firstWords.size() != words.size()) {
            return false;
        }
        for (int j = 0; j < words.size(); ++j) {
            Word firstWord = firstWords.get(j);
            Word word = words.get(j);
            if (firstWord.isArg() && word.isArg() && Objects.equal((Object)firstWord.getArgumentInfo().getArgumentName(), (Object)word.getArgumentInfo().getArgumentName()) || firstWord.equals(word)) continue;
            return false;
        }
        return true;
    }

    private void reduceMatrix(ScenarioModel scenarioModel, List<CaseArguments> argumentMatrix) {
        int nArguments = argumentMatrix.get((int)0).arguments.size();
        LinkedHashMap usedParameters = Maps.newLinkedHashMap();
        ArrayList parameterReplacements = Lists.newArrayList();
        HashSet usedNames = Sets.newHashSet();
        for (int iArg = 0; iArg < nArguments; ++iArg) {
            List<Word> arguments = this.getArgumentsOfAllCases(argumentMatrix, iArg);
            if (this.allArgumentsAreEqual(arguments)) continue;
            ParameterReplacement replacement = new ParameterReplacement();
            replacement.arguments = arguments;
            parameterReplacements.add(replacement);
            Collection<ParameterMatch> parameterMatches = this.getPossibleParameterNames(argumentMatrix, iArg);
            if (!parameterMatches.isEmpty()) {
                ParameterMatch match;
                Iterator<ParameterMatch> iterator = parameterMatches.iterator();
                replacement.match = match = iterator.next();
                replacement.replacementName = match.parameter;
                if (usedParameters.containsKey(match.parameter)) {
                    ParameterReplacement usedReplacement = (ParameterReplacement)usedParameters.get(match.parameter);
                    if (match.formattedValueMatches && !usedReplacement.match.formattedValueMatches) {
                        usedReplacement.updateToStepParameterName(usedNames);
                    }
                }
                usedNames.add(replacement.replacementName);
                usedParameters.put(match.parameter, replacement);
                if (!iterator.hasNext()) continue;
                log.debug("Multiple parameter matches found for argument " + iArg + ": " + parameterMatches + ". Took the first one.");
                continue;
            }
            replacement.updateToStepParameterName(usedNames);
        }
        for (ParameterReplacement replacement : parameterReplacements) {
            boolean duplicate = scenarioModel.getDerivedParameters().contains(replacement.replacementName);
            if (!duplicate) {
                scenarioModel.addDerivedParameter(replacement.replacementName);
            }
            for (int i = 0; i < replacement.arguments.size(); ++i) {
                Word word = replacement.arguments.get(i);
                word.getArgumentInfo().setParameterName(replacement.replacementName);
                if (duplicate) continue;
                scenarioModel.getCase(i).addDerivedArguments(word.getFormattedValue());
            }
        }
    }

    private Collection<ParameterMatch> getPossibleParameterNames(List<CaseArguments> argumentMatrix, int iArg) {
        Map<String, ParameterMatch> result = this.toMap(argumentMatrix.get((int)0).arguments.get((int)iArg).params);
        for (int i = 1; i < argumentMatrix.size(); ++i) {
            Map<String, ParameterMatch> map = this.toMap(argumentMatrix.get((int)i).arguments.get((int)iArg).params);
            for (String key : Lists.newArrayList(result.keySet())) {
                if (!map.containsKey(key)) {
                    result.remove(key);
                    continue;
                }
                result.get((Object)key).formattedValueMatches &= map.get((Object)key).formattedValueMatches;
            }
        }
        return result.values();
    }

    private Map<String, ParameterMatch> toMap(Set<ParameterMatch> params) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (ParameterMatch match : params) {
            result.put(match.parameter, match);
        }
        return result;
    }

    private List<Word> getArgumentsOfAllCases(List<CaseArguments> argumentMatrix, int iArg) {
        ArrayList result = Lists.newArrayList();
        for (int iCase = 0; iCase < argumentMatrix.size(); ++iCase) {
            result.add(argumentMatrix.get((int)iCase).get((int)iArg).word);
        }
        return result;
    }

    private boolean allArgumentsAreEqual(List<Word> arguments) {
        Word firstWord = arguments.get(0);
        for (int i = 1; i < arguments.size(); ++i) {
            Word word = arguments.get(i);
            if (firstWord.equals(word)) continue;
            return false;
        }
        return true;
    }

    static class CollectPhase
    extends ReportModelVisitor {
        List<CaseArguments> argumentMatrix = Lists.newArrayList();
        List<ArgumentHolder> argumentsOfCurrentCase;
        List<List<Word>> allWords = Lists.newArrayList();
        List<Word> allWordsOfCurrentCase;
        ScenarioCaseModel currentCase;
        final ScenarioModel scenarioModel;

        public CollectPhase(ScenarioModel model) {
            this.scenarioModel = model;
        }

        @Override
        public void visit(ScenarioCaseModel scenarioCase) {
            this.currentCase = scenarioCase;
            this.argumentsOfCurrentCase = Lists.newArrayList();
            this.argumentMatrix.add(new CaseArguments(this.currentCase, this.argumentsOfCurrentCase));
            this.allWordsOfCurrentCase = Lists.newArrayList();
            this.allWords.add(this.allWordsOfCurrentCase);
        }

        @Override
        public void visit(StepModel methodModel) {
            for (Word word : methodModel.words) {
                if (word.isArg()) {
                    ArgumentHolder holder = new ArgumentHolder();
                    holder.word = word;
                    holder.params = this.getMatchingParameters(word);
                    this.argumentsOfCurrentCase.add(holder);
                }
                this.allWordsOfCurrentCase.add(word);
            }
        }

        private Set<ParameterMatch> getMatchingParameters(Word word) {
            LinkedHashSet matchingParameters = Sets.newLinkedHashSet();
            for (int i = 0; i < this.currentCase.getExplicitArguments().size(); ++i) {
                String argumentValue = this.currentCase.getExplicitArguments().get(i);
                if (!Objects.equal((Object)word.getValue(), (Object)argumentValue) || i >= this.scenarioModel.getExplicitParameters().size()) continue;
                ParameterMatch match = new ParameterMatch();
                match.index = i;
                match.parameter = this.scenarioModel.getExplicitParameters().get(i);
                match.formattedValueMatches = Objects.equal((Object)word.getFormattedValue(), (Object)argumentValue);
                matchingParameters.add(match);
            }
            return matchingParameters;
        }
    }

    static class ArgumentHolder {
        Word word;
        Set<ParameterMatch> params;

        ArgumentHolder() {
        }
    }

    static class ParameterMatch {
        String parameter;
        int index;
        boolean formattedValueMatches;

        ParameterMatch() {
        }
    }

    static class ParameterReplacement {
        List<Word> arguments;
        ParameterMatch match;
        String replacementName;
        boolean isStepParameterName;

        ParameterReplacement() {
        }

        public void updateToStepParameterName(Set<String> usedNames) {
            String name = this.arguments.get(0).getArgumentInfo().getArgumentName();
            int i = 1;
            String suffix = "";
            while (usedNames.contains(name + suffix)) {
                suffix = "" + ++i;
            }
            this.replacementName = name + suffix;
            usedNames.add(this.replacementName);
            this.isStepParameterName = true;
        }
    }

    private static final class CaseArguments {
        final ScenarioCaseModel caseModel;
        final List<ArgumentHolder> arguments;

        private CaseArguments(ScenarioCaseModel model, List<ArgumentHolder> arguments) {
            this.caseModel = model;
            this.arguments = arguments;
        }

        public ArgumentHolder get(int i) {
            return this.arguments.get(i);
        }
    }
}

