/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.html;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.tngtech.jgiven.report.html.StaticHtmlReportGenerator;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PackageTocBuilder {
    private final List<StaticHtmlReportGenerator.ModelFile> sortedModels;
    private final Map<String, PackageToc> tocs = Maps.newLinkedHashMap();

    public PackageTocBuilder(List<StaticHtmlReportGenerator.ModelFile> models) {
        this.sortedModels = models;
    }

    public PackageToc getRootPackageToc() {
        this.calculatePackageTocs();
        this.getOrCreate("");
        ArrayDeque tocCopy = Queues.newArrayDeque(this.tocs.values());
        HashMap handledTocs = Maps.newHashMap();
        while (!tocCopy.isEmpty()) {
            PackageToc toc = (PackageToc)tocCopy.remove();
            if (toc.name.equals("")) continue;
            PackageToc parentToc = this.getOrCreate(toc.getParentName());
            parentToc.packages.add(toc);
            handledTocs.put(toc.name, toc);
            if (handledTocs.containsKey(parentToc.name)) continue;
            tocCopy.add(parentToc);
            handledTocs.put(parentToc.name, parentToc);
        }
        for (PackageToc toc : this.tocs.values()) {
            toc.sort();
        }
        return this.tocs.get("");
    }

    private void calculatePackageTocs() {
        for (StaticHtmlReportGenerator.ModelFile file : this.sortedModels) {
            String packageName = file.model.getPackageName();
            PackageToc packageToc = this.getOrCreate(packageName);
            packageToc.files.add(file);
        }
    }

    private PackageToc getOrCreate(String packageName) {
        PackageToc packageToc = this.tocs.get(packageName);
        if (packageToc == null) {
            packageToc = new PackageToc();
            packageToc.name = packageName;
            this.tocs.put(packageName, packageToc);
        }
        return packageToc;
    }

    static class PackageToc {
        String name;
        List<PackageToc> packages = Lists.newArrayList();
        List<StaticHtmlReportGenerator.ModelFile> files = Lists.newArrayList();

        PackageToc() {
        }

        public String getParentName() {
            int lastIndexOf = this.name.lastIndexOf(46);
            if (lastIndexOf == -1) {
                return "";
            }
            return this.name.substring(0, lastIndexOf);
        }

        public String getLastName() {
            int lastIndexOf = this.name.lastIndexOf(46);
            if (lastIndexOf == -1) {
                return this.name;
            }
            return this.name.substring(lastIndexOf + 1);
        }

        void sortFiles() {
            Comparator<StaticHtmlReportGenerator.ModelFile> comparator = new Comparator<StaticHtmlReportGenerator.ModelFile>(){

                @Override
                public int compare(StaticHtmlReportGenerator.ModelFile o1, StaticHtmlReportGenerator.ModelFile o2) {
                    return o1.model.getClassName().compareTo(o2.model.getClassName());
                }
            };
            Collections.sort(this.files, comparator);
        }

        void sortPackages() {
            Comparator<PackageToc> comparator = new Comparator<PackageToc>(){

                @Override
                public int compare(PackageToc o1, PackageToc o2) {
                    return o1.name.compareTo(o2.name);
                }
            };
            Collections.sort(this.packages, comparator);
        }

        void sort() {
            this.sortFiles();
            this.sortPackages();
        }
    }
}

