/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModel;
import com.tngtech.jgiven.report.model.ReportModelVisitor;
import com.tngtech.jgiven.report.model.ReportStatistics;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import java.util.List;

public class StatisticsCalculator {
    public ReportStatistics getStatistics(ReportModel model) {
        ReportStatistics result = new ReportStatistics();
        model.accept(new StatisticsVisitor(result));
        return result;
    }

    public ReportStatistics getStatistics(List<ScenarioModel> models) {
        ReportStatistics result = new ReportStatistics();
        for (ScenarioModel model : models) {
            model.accept(new StatisticsVisitor(result));
        }
        return result;
    }

    private static class StatisticsVisitor
    extends ReportModelVisitor {
        final ReportStatistics statistics;

        public StatisticsVisitor(ReportStatistics statistics) {
            this.statistics = statistics;
        }

        @Override
        public void visit(ReportModel reportModel) {
            ++this.statistics.numClasses;
        }

        @Override
        public void visit(ScenarioModel scenarioModel) {
            ++this.statistics.numScenarios;
            this.statistics.durationInNanos += scenarioModel.getDurationInNanos();
            ExecutionStatus executionStatus = scenarioModel.getExecutionStatus();
            if (executionStatus == ExecutionStatus.FAILED) {
                ++this.statistics.numFailedScenarios;
            } else if (executionStatus == ExecutionStatus.NONE_IMPLEMENTED || executionStatus == ExecutionStatus.PARTIALLY_IMPLEMENTED) {
                ++this.statistics.numPendingScenarios;
            } else {
                ++this.statistics.numSuccessfulScenarios;
            }
        }

        @Override
        public void visit(ScenarioCaseModel scenarioCase) {
            ++this.statistics.numCases;
            if (!scenarioCase.success) {
                ++this.statistics.numFailedCases;
            }
        }

        @Override
        public void visit(StepModel methodModel) {
            ++this.statistics.numSteps;
        }
    }
}

