/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.model;

import com.google.common.base.Objects;
import com.tngtech.jgiven.report.model.ArgumentInfo;

public class Word {
    private String value;
    private boolean isIntroWord;
    private ArgumentInfo argumentInfo;
    private boolean isDifferent;

    public Word() {
    }

    public Word(String value) {
        this.setValue(value);
    }

    public Word(String value, boolean isIntroWord) {
        this.setValue(value);
        this.setIntroWord(isIntroWord);
    }

    public static Word argWord(String argumentName, String value) {
        return Word.argWord(argumentName, value, null);
    }

    public static Word argWord(String argumentName, String value, String formattedValue) {
        Word word = new Word(value);
        word.argumentInfo = new ArgumentInfo();
        word.argumentInfo.setArgumentName(argumentName);
        word.argumentInfo.setFormattedValue(formattedValue);
        return word;
    }

    public String getFormattedValue() {
        if (this.isArg() && this.getArgumentInfo().getFormattedValue() != null) {
            return this.getArgumentInfo().getFormattedValue();
        }
        return this.getValue();
    }

    public static Word introWord(String value) {
        return new Word(value, true);
    }

    public void setValue(String name) {
        this.value = name;
    }

    public void append(String word) {
        this.setValue(this.getValue() + " " + word);
    }

    public boolean isArg() {
        return this.argumentInfo != null;
    }

    public ArgumentInfo getArgumentInfo() {
        return this.argumentInfo;
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isIntroWord(), this.getValue(), this.argumentInfo});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Word other = (Word)obj;
        return Objects.equal((Object)this.isIntroWord(), (Object)other.isIntroWord()) && Objects.equal((Object)this.getValue(), (Object)other.getValue()) && Objects.equal((Object)this.argumentInfo, (Object)other.argumentInfo);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isIntroWord() {
        return this.isIntroWord;
    }

    public void setIntroWord(boolean isIntroWord) {
        this.isIntroWord = isIntroWord;
    }

    public void setIsDifferent(boolean b) {
        this.isDifferent = b;
    }

    public boolean isDifferent() {
        return this.isDifferent;
    }
}

