/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.report.text;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import com.tngtech.jgiven.report.model.ScenarioCaseModel;
import com.tngtech.jgiven.report.model.ScenarioModel;
import com.tngtech.jgiven.report.model.StepModel;
import com.tngtech.jgiven.report.model.Word;
import com.tngtech.jgiven.report.text.PlainTextScenarioWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class DataTablePlainTextScenarioWriter
extends PlainTextScenarioWriter {
    public DataTablePlainTextScenarioWriter(PrintWriter writer, boolean withColor) {
        super(writer, withColor);
    }

    @Override
    public void visit(StepModel stepModel) {
        if (this.currentCaseModel.caseNr > 1) {
            return;
        }
        super.visit(stepModel);
    }

    @Override
    protected String wordToString(Word word) {
        if (word.isArg() && word.getArgumentInfo().isParameter()) {
            String parameterName = word.getArgumentInfo().getParameterName();
            return "<" + parameterName + ">";
        }
        return super.wordToString(word);
    }

    @Override
    protected void printCaseLine(ScenarioCaseModel scenarioCase) {
    }

    @Override
    public void visitEnd(ScenarioCaseModel scenarioCase) {
        if (scenarioCase.caseNr == 1) {
            super.visitEnd(scenarioCase);
        }
    }

    @Override
    public void visitEnd(ScenarioModel scenarioModel) {
        List<List<String>> dataTableModel = this.getDataTableModel(scenarioModel);
        StringBuilder formatBuilder = new StringBuilder();
        StringBuilder lineBuilder = new StringBuilder();
        List<ColumnSpec> columnWidths = this.getColumnSpecs(dataTableModel);
        for (ColumnSpec spec : columnWidths) {
            formatBuilder.append("| %");
            if (spec.leftAligned) {
                formatBuilder.append("-");
            }
            formatBuilder.append(spec.width + "s ");
            lineBuilder.append("+");
            lineBuilder.append(Strings.repeat((String)"-", (int)(spec.width + 2)));
        }
        formatBuilder.append("|");
        lineBuilder.append("+");
        String formatString = formatBuilder.toString();
        String caseIndent = "    ";
        this.writer.println("  Cases:\n");
        this.writer.println(caseIndent + String.format(formatString, dataTableModel.get(0).toArray()));
        this.writer.println(caseIndent + lineBuilder);
        for (int nrow = 1; nrow < dataTableModel.size(); ++nrow) {
            this.writer.println(caseIndent + String.format(formatString, dataTableModel.get(nrow).toArray()));
        }
    }

    private List<List<String>> getDataTableModel(ScenarioModel scenarioModel) {
        ArrayList result = Lists.newArrayList();
        ArrayList headerRow = Lists.newArrayList();
        headerRow.add("#");
        headerRow.addAll(scenarioModel.getDerivedParameters());
        headerRow.add("Status");
        result.add(headerRow);
        int i = 1;
        for (ScenarioCaseModel c : scenarioModel.getScenarioCases()) {
            ArrayList row = Lists.newArrayList();
            row.add("" + i++);
            row.addAll(c.getDerivedArguments());
            row.add(this.getStatusText(c));
            result.add(row);
        }
        return result;
    }

    private String getStatusText(ScenarioCaseModel c) {
        if (c.success) {
            return "Success";
        }
        return "Failed: " + c.errorMessage;
    }

    private List<ColumnSpec> getColumnSpecs(List<List<String>> dataTableModel) {
        Object[] result = new ColumnSpec[dataTableModel.get(0).size()];
        for (int nrow = 0; nrow < dataTableModel.size(); ++nrow) {
            List<String> row = dataTableModel.get(nrow);
            for (int ncol = 0; ncol < row.size(); ++ncol) {
                String value = row.get(ncol);
                int width = value.length();
                Object spec = result[ncol];
                if (spec == null) {
                    result[ncol] = spec = new ColumnSpec();
                }
                if (width > ((ColumnSpec)spec).width) {
                    ((ColumnSpec)spec).width = width;
                }
                if (nrow <= 0 || Doubles.tryParse((String)value) != null) continue;
                ((ColumnSpec)spec).leftAligned = true;
            }
        }
        return Lists.newArrayList((Object[])result);
    }

    static class ColumnSpec {
        int width;
        boolean leftAligned;

        ColumnSpec() {
        }
    }
}

