/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.junit5;

import com.tngtech.jgiven.base.ScenarioTestBase;
import com.tngtech.jgiven.config.ConfigurationUtil;
import com.tngtech.jgiven.impl.ScenarioBase;
import com.tngtech.jgiven.impl.ScenarioHolder;
import com.tngtech.jgiven.report.impl.CommonReportHelper;
import com.tngtech.jgiven.report.model.ExecutionStatus;
import com.tngtech.jgiven.report.model.ReportModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public class JGivenExtension
implements TestInstancePostProcessor,
BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{"com.tngtech.jgiven"});
    private static final String REPORT_MODEL = "report-model";

    public void beforeAll(ContainerExtensionContext context) throws Exception {
        ReportModel reportModel = new ReportModel();
        reportModel.setTestClass((Class)context.getTestClass().get());
        if (!context.getDisplayName().equals(((Class)context.getTestClass().get()).getSimpleName())) {
            reportModel.setName(context.getDisplayName());
        }
        context.getStore(NAMESPACE).put((Object)REPORT_MODEL, (Object)reportModel);
        ConfigurationUtil.getConfiguration((Class)((Class)context.getTestClass().get())).configureTag(Tag.class).description("JUnit 5 Tag").color("orange");
    }

    public void afterAll(ContainerExtensionContext context) throws Exception {
        new CommonReportHelper().finishReport((ReportModel)context.getStore(NAMESPACE).get((Object)REPORT_MODEL));
    }

    public void beforeEach(TestExtensionContext context) throws Exception {
        ArrayList args = new ArrayList();
        this.getScenario().startScenario((Class)context.getTestClass().get(), (Method)context.getTestMethod().get(), args);
    }

    public void afterEach(TestExtensionContext context) throws Exception {
        ScenarioBase scenario = this.getScenario();
        try {
            if (context.getTestException().isPresent()) {
                scenario.getExecutor().failed((Throwable)context.getTestException().get());
            }
            scenario.finished();
            Assumptions.assumeTrue((boolean)EnumSet.of(ExecutionStatus.SUCCESS, ExecutionStatus.FAILED).contains(scenario.getScenarioModel().getExecutionStatus()));
        }
        catch (Exception e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            ScenarioHolder.get().removeScenarioOfCurrentThread();
        }
    }

    private ScenarioBase getScenario() {
        return ScenarioHolder.get().getScenarioOfCurrentThread();
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        Object scenario = ScenarioHolder.get().getScenarioOfCurrentThread();
        if (scenario == null) {
            scenario = testInstance instanceof ScenarioTestBase ? ((ScenarioTestBase)testInstance).getScenario() : new ScenarioBase();
            ReportModel reportModel = (ReportModel)context.getStore(NAMESPACE).get((Object)REPORT_MODEL);
            scenario.setModel(reportModel);
            ScenarioHolder.get().setScenarioOfCurrentThread(scenario);
        }
        scenario.getExecutor().injectStages(testInstance);
        scenario.getExecutor().readScenarioState(testInstance);
    }
}

