/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.jgiven.maven;

import com.tngtech.jgiven.report.AbstractReportConfig;
import com.tngtech.jgiven.report.ReportGenerator;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportConfig;
import com.tngtech.jgiven.report.asciidoc.AsciiDocReportGenerator;
import com.tngtech.jgiven.report.html5.Html5ReportConfig;
import com.tngtech.jgiven.report.text.PlainTextReportConfig;
import com.tngtech.jgiven.report.text.PlainTextReportGenerator;
import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="report", defaultPhase=LifecyclePhase.VERIFY)
public class JGivenReportMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.directory}/jgiven-reports/html")
    private File outputDirectory;
    @Parameter(defaultValue="${project.build.directory}/jgiven-reports/json")
    private File sourceDirectory;
    @Parameter(defaultValue="src/test/resources/jgiven/custom.css")
    private File customCssFile;
    @Parameter(defaultValue="src/test/resources/jgiven/custom.js")
    private File customJsFile;
    @Parameter(defaultValue="html")
    private String format;
    @Parameter(defaultValue="JGiven Report")
    private String title;
    @Parameter(defaultValue="false")
    boolean excludeEmptyScenarios;
    @Parameter(defaultValue="true")
    boolean thumbnailsAreShown;

    public void execute() throws MojoExecutionException {
        try {
            AsciiDocReportGenerator generator;
            AsciiDocReportConfig config;
            if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
                throw new MojoExecutionException("Error while trying to create output directory " + this.outputDirectory);
            }
            this.getLog().info((CharSequence)("JGiven HTML report source directory: " + this.sourceDirectory));
            this.getLog().info((CharSequence)("JGiven HTML report output directory: " + this.outputDirectory));
            if (this.customCssFile != null && this.customCssFile.exists()) {
                this.getLog().info((CharSequence)("JGiven HTML report custom CSS file: " + this.customCssFile));
            }
            if (this.customJsFile != null && this.customJsFile.exists()) {
                this.getLog().info((CharSequence)("JGiven HTML report custom JS file: " + this.customJsFile));
            }
            this.getLog().info((CharSequence)("Generating HTML reports to " + this.outputDirectory + "..."));
            ReportGenerator.Format parsedFormat = ReportGenerator.Format.fromStringOrNull((String)this.format);
            switch (parsedFormat) {
                case ASCIIDOC: {
                    config = new AsciiDocReportConfig();
                    generator = new AsciiDocReportGenerator();
                    break;
                }
                case TEXT: {
                    config = new PlainTextReportConfig();
                    generator = new PlainTextReportGenerator();
                    break;
                }
                default: {
                    Html5ReportConfig customConf = new Html5ReportConfig();
                    customConf.setShowThumbnails(this.thumbnailsAreShown);
                    customConf.setCustomCss(this.customCssFile);
                    customConf.setCustomJs(this.customJsFile);
                    config = customConf;
                    generator = ReportGenerator.generateHtml5Report();
                }
            }
            config.setTitle(this.title);
            config.setSourceDir(this.sourceDirectory);
            config.setTargetDir(this.outputDirectory);
            config.setExcludeEmptyScenarios(Boolean.valueOf(this.excludeEmptyScenarios));
            generator.generateWithConfig((AbstractReportConfig)config);
            this.getLog().info((CharSequence)"-------------------------------------------------------------------");
            this.getLog().info((CharSequence)("Generated JGiven HTML reports to directory " + this.outputDirectory));
            this.getLog().info((CharSequence)"-------------------------------------------------------------------");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error while trying to generate HTML reports", e);
        }
    }
}

