/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderFrameworkMethod;
import com.tngtech.java.junit.dataprovider.common.Preconditions;
import com.tngtech.java.junit.dataprovider.internal.DataConverter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.runners.model.FrameworkMethod;

public class TestGenerator {
    private final DataConverter dataConverter;
    static final Map<FrameworkMethod, Object> dataProviderDataCache = new HashMap<FrameworkMethod, Object>();

    public TestGenerator(DataConverter dataConverter) {
        this.dataConverter = Preconditions.checkNotNull(dataConverter, "dataConverter must not be null");
    }

    public List<FrameworkMethod> generateExplodedTestMethodsFor(FrameworkMethod testMethod, FrameworkMethod dataProviderMethod) {
        if (testMethod == null) {
            return Collections.emptyList();
        }
        if (dataProviderMethod != null) {
            try {
                return this.explodeTestMethod(testMethod, dataProviderMethod);
            }
            catch (Exception e) {
                throw new Error(String.format("Cannot explode '%s.%s' using '%s' due to: %s", testMethod.getMethod().getDeclaringClass().getSimpleName(), testMethod.getName(), dataProviderMethod.getName(), e.getMessage()), e);
            }
        }
        DataProvider dataProvider = (DataProvider)testMethod.getAnnotation(DataProvider.class);
        if (dataProvider != null) {
            try {
                return this.explodeTestMethod(testMethod, dataProvider);
            }
            catch (Exception e) {
                throw new Error(String.format("Exception while exploding '%s.%s' using its '@DataProvider' due to: %s", testMethod.getMethod().getDeclaringClass().getSimpleName(), testMethod.getName(), e.getMessage()), e);
            }
        }
        return Arrays.asList(testMethod);
    }

    List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, FrameworkMethod dataProviderMethod) {
        Object data;
        DataProvider dataProvider = (DataProvider)dataProviderMethod.getAnnotation(DataProvider.class);
        if (dataProviderDataCache.containsKey(dataProviderMethod)) {
            data = dataProviderDataCache.get(dataProviderMethod);
        } else {
            try {
                Class<?>[] parameterTypes = dataProviderMethod.getMethod().getParameterTypes();
                data = parameterTypes.length > 0 ? dataProviderMethod.invokeExplosively(null, new Object[]{testMethod}) : dataProviderMethod.invokeExplosively(null, new Object[0]);
                if (dataProvider.cache()) {
                    dataProviderDataCache.put(dataProviderMethod, data);
                }
            }
            catch (Throwable t) {
                throw new IllegalArgumentException(String.format("Exception while invoking dataprovider method '%s': %s", dataProviderMethod.getName(), t.getMessage()), t);
            }
        }
        return this.explodeTestMethod(testMethod, data, dataProvider);
    }

    List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, DataProvider dataProvider) {
        return this.explodeTestMethod(testMethod, dataProvider.value(), dataProvider);
    }

    private List<FrameworkMethod> explodeTestMethod(FrameworkMethod testMethod, Object data, DataProvider dataProvider) {
        Method method = testMethod.getMethod();
        List<Object[]> converted = this.dataConverter.convert(data, method.isVarArgs(), method.getParameterTypes(), dataProvider);
        if (converted.isEmpty()) {
            throw new IllegalArgumentException("Could not create test methods using probably 'null' or 'empty' dataprovider");
        }
        int idx = 0;
        ArrayList<FrameworkMethod> result = new ArrayList<FrameworkMethod>();
        for (Object[] parameters : converted) {
            result.add(new DataProviderFrameworkMethod(method, idx++, parameters, dataProvider.format()));
        }
        return result;
    }
}

