/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider;

import com.tngtech.junit.dataprovider.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class DataProviders {
    public static Object[] $(Object ... args) {
        return args;
    }

    public static Object[][] $$(Object[] ... args) {
        return args;
    }

    public static Object[][] testForEach(Object ... args) {
        Object[][] result = new Object[args.length][1];
        for (int idx = 0; idx < args.length; ++idx) {
            result[idx][0] = args[idx];
        }
        return result;
    }

    public static <E extends Enum<E>> Object[][] testForEach(Class<E> enumClass) {
        Preconditions.checkNotNull(enumClass, "'enumClass' must not be null");
        return DataProviders.testForEach(enumClass.getEnumConstants());
    }

    public static Object[][] crossProduct(Object[][] rows1, Object[][] rows2) {
        Object[][] rowsOut = new Object[rows1.length * rows2.length][];
        int indexOut = 0;
        for (Object[] row1 : rows1) {
            for (Object[] row2 : rows2) {
                Object[] rowOut = new Object[row1.length + row2.length];
                System.arraycopy(row1, 0, rowOut, 0, row1.length);
                System.arraycopy(row2, 0, rowOut, row1.length, row2.length);
                rowsOut[indexOut++] = rowOut;
            }
        }
        return rowsOut;
    }

    public static Object[][] crossProductSingleArg(Object[] rows1, Object[] rows2) {
        Object[][] rowsOut = new Object[rows1.length * rows2.length][];
        int indexOut = 0;
        for (Object entry1 : rows1) {
            for (Object entry2 : rows2) {
                rowsOut[indexOut++] = new Object[]{entry1, entry2};
            }
        }
        return rowsOut;
    }

    public static <T extends Iterable<?>, V extends Iterable<?>> Object[][] crossProduct(Iterable<T> rows1, Iterable<V> rows2) {
        ArrayList<List<Object>> rowsOut = new ArrayList<List<Object>>();
        for (Iterable row1 : rows1) {
            for (Iterable row2 : rows2) {
                rowsOut.add(DataProviders.concat(row1, row2));
            }
        }
        return DataProviders.convert(rowsOut);
    }

    public static Object[][] crossProductSingleArg(Iterable<?> rows1, Iterable<?> rows2) {
        ArrayList<List<Object>> rowsOut = new ArrayList<List<Object>>();
        for (Object row1 : rows1) {
            for (Object row2 : rows2) {
                rowsOut.add(Arrays.asList(row1, row2));
            }
        }
        return DataProviders.convert(rowsOut);
    }

    private static List<Object> concat(Iterable<?> row1, Iterable<?> row2) {
        ArrayList<Object> outs = new ArrayList<Object>();
        for (Object t : row1) {
            outs.add(t);
        }
        for (Object v : row2) {
            outs.add(v);
        }
        return outs;
    }

    private static Object[][] convert(List<List<Object>> rows) {
        Object[][] result = new Object[rows.size()][];
        int indexOut = 0;
        for (List<Object> row : rows) {
            result[indexOut++] = row.toArray();
        }
        return result;
    }
}

