/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.convert;

import com.tngtech.junit.dataprovider.Preconditions;
import com.tngtech.junit.dataprovider.convert.ConverterContext;
import java.util.ArrayList;
import java.util.List;

public class DataConverter {
    public List<Object[]> convert(Object data, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext context) {
        Preconditions.checkNotNull(parameterTypes, "'parameterTypes' must not be null");
        Preconditions.checkArgument(parameterTypes.length != 0, "'parameterTypes' must not be empty");
        if (data instanceof Object[][]) {
            return this.convert((Object[][])data, isVarargs, parameterTypes, context);
        }
        if (data instanceof String[]) {
            Preconditions.checkState(context != null, "'context' must not be null for 'String[]' data");
            return this.convert((String[])data, isVarargs, parameterTypes, context);
        }
        if (data instanceof Object[]) {
            return this.convert((Object[])data, isVarargs, parameterTypes, context);
        }
        if (data instanceof Iterable) {
            Iterable iterableData = (Iterable)data;
            return this.convert(iterableData, isVarargs, parameterTypes, context);
        }
        throw new ClassCastException(String.format("Cannot cast to either Object[][], Object[], String[], or Iterable because data was: %s", data));
    }

    private List<Object[]> convert(Object[][] data, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext config) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object[] arguments : data) {
            result.add(config.getObjectArrayConverter().convert(arguments, isVarargs, parameterTypes));
        }
        return result;
    }

    private List<Object[]> convert(String[] data, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext context) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int idx = 0;
        for (String argString : data) {
            result.add(context.getStringConverter().convert(argString, isVarargs, parameterTypes, context, idx++));
        }
        return result;
    }

    private List<Object[]> convert(Object[] data, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext context) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object argument : data) {
            result.add(context.getSingleArgConverter().convert(argument, isVarargs, parameterTypes));
        }
        return result;
    }

    private List<Object[]> convert(Iterable<?> data, boolean isVarargs, Class<?>[] parameterTypes, ConverterContext context) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (Object arguments : data) {
            if (arguments != null && Iterable.class.isAssignableFrom(arguments.getClass())) {
                Iterable iterable = (Iterable)arguments;
                result.add(context.getObjectArrayConverter().convert(this.toArray(iterable), isVarargs, parameterTypes));
                continue;
            }
            result.add(context.getSingleArgConverter().convert(arguments, isVarargs, parameterTypes));
        }
        return result;
    }

    private Object[] toArray(Iterable<?> iterable) {
        ArrayList list = new ArrayList();
        for (Object element : iterable) {
            list.add(element);
        }
        return list.toArray();
    }
}

