/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.placeholder;

import com.tngtech.junit.dataprovider.placeholder.BasePlaceholder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

abstract class AbstractArgumentPlaceholder
extends BasePlaceholder {
    protected static final String STRING_NULL = "<null>";
    protected static final String STRING_EMPTY = "<empty string>";
    protected static final String STRING_NON_PRINTABLE = "<np>";

    AbstractArgumentPlaceholder(String placeholderRegex) {
        super(placeholderRegex);
    }

    FromAndTo calcFromAndToForSubscriptAndArguments(String placeholder, int subscriptStartIndex, int argumentCount) {
        int to;
        int from;
        String subscript = placeholder.substring(subscriptStartIndex, placeholder.length() - 1);
        if (subscript.contains("..")) {
            String[] split = subscript.split("\\.\\.");
            from = Integer.parseInt(split[0]);
            to = Integer.parseInt(split[1]);
        } else {
            to = from = Integer.parseInt(subscript);
        }
        from = from >= 0 ? from : argumentCount + from;
        to = to >= 0 ? to + 1 : argumentCount + to + 1;
        return new FromAndTo(from, to);
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="false positive if 'param.toString()' returns 'null'")
    protected String format(Object param) {
        if (param == null) {
            return STRING_NULL;
        }
        if (param.getClass().isArray()) {
            if (param.getClass().getComponentType().isPrimitive()) {
                return this.formatPrimitiveArray(param);
            }
            return "[" + this.formatArray((Object[])param) + "]";
        }
        if (param instanceof String && ((String)param).isEmpty()) {
            return STRING_EMPTY;
        }
        String result = param instanceof String ? (String)param : param.toString();
        if (result == null) {
            return STRING_NULL;
        }
        result = result.replaceAll("\u0000", "\\\\0").replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n");
        return this.replaceNonPrintableChars(result, STRING_NON_PRINTABLE);
    }

    private String formatPrimitiveArray(Object primitiveArray) {
        Class<?> componentType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.equals(componentType)) {
            return Arrays.toString((boolean[])primitiveArray);
        }
        if (Byte.TYPE.equals(componentType)) {
            return Arrays.toString((byte[])primitiveArray);
        }
        if (Character.TYPE.equals(componentType)) {
            return Arrays.toString((char[])primitiveArray);
        }
        if (Short.TYPE.equals(componentType)) {
            return Arrays.toString((short[])primitiveArray);
        }
        if (Integer.TYPE.equals(componentType)) {
            return Arrays.toString((int[])primitiveArray);
        }
        if (Long.TYPE.equals(componentType)) {
            return Arrays.toString((long[])primitiveArray);
        }
        if (Float.TYPE.equals(componentType)) {
            return Arrays.toString((float[])primitiveArray);
        }
        if (Double.TYPE.equals(componentType)) {
            return Arrays.toString((double[])primitiveArray);
        }
        throw new IllegalStateException("Called 'formatPrimitiveArray' on non-primitive array");
    }

    private String formatArray(Object[] array) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            stringBuilder.append(this.format(array[i]));
            if (i >= array.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private String replaceNonPrintableChars(String input, String replacement) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        block3: for (int offset = 0; offset < input.length(); offset += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(offset);
            switch (Character.getType(codePoint)) {
                case 0: 
                case 15: 
                case 16: 
                case 18: 
                case 19: {
                    result.append(replacement);
                    continue block3;
                }
            }
            result.append(Character.toChars(codePoint));
        }
        return result.toString();
    }

    protected static final class FromAndTo {
        protected final int from;
        protected final int to;

        protected FromAndTo(int from, int to) {
            this.from = from;
            this.to = to;
        }
    }
}

