/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.junit.dataprovider.placeholder;

import com.tngtech.junit.dataprovider.Preconditions;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ReplacementData {
    private final Method testMethod;
    private final int testIndex;
    private final List<Object> arguments;

    public static ReplacementData of(Method testMethod, int testIndex, List<Object> arguments) {
        return new ReplacementData(testMethod, testIndex, arguments);
    }

    private ReplacementData(Method testMethod, int testIndex, List<Object> arguments) {
        this.testMethod = Preconditions.checkNotNull(testMethod, "'testMethod' must not be null");
        this.testIndex = testIndex;
        this.arguments = new ArrayList<Object>((Collection)Preconditions.checkNotNull(arguments, "'arguments' must not be null"));
    }

    public Method getTestMethod() {
        return this.testMethod;
    }

    public int getTestIndex() {
        return this.testIndex;
    }

    public List<Object> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.testIndex;
        result = 31 * result + (this.arguments == null ? 0 : this.arguments.hashCode());
        result = 31 * result + (this.testMethod == null ? 0 : this.testMethod.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplacementData other = (ReplacementData)obj;
        if (this.testIndex != other.testIndex) {
            return false;
        }
        if (this.arguments == null ? other.arguments != null : !this.arguments.equals(other.arguments)) {
            return false;
        }
        return !(this.testMethod == null ? other.testMethod != null : !this.testMethod.equals(other.testMethod));
    }

    public String toString() {
        return "ReplacementData [testMethod=" + this.testMethod + ", testIndex=" + this.testIndex + ", arguments=" + this.arguments + "]";
    }
}

