/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.processors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.trivago.cluecumber.exceptions.filesystem.FileCreationException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.json.pojo.Element;
import com.trivago.cluecumber.json.pojo.Embedding;
import com.trivago.cluecumber.json.pojo.ResultMatch;
import com.trivago.cluecumber.json.pojo.Step;
import com.trivago.cluecumber.logging.CluecumberLogger;
import com.trivago.cluecumber.properties.PropertyManager;
import io.gsonfire.PostProcessor;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.plexus.util.Base64;

@Singleton
public class ElementJsonPostProcessor
implements PostProcessor<Element> {
    private final PropertyManager propertyManager;
    private final FileIO fileIO;
    private final CluecumberLogger logger;
    private int attachmentIndex = 1;

    @Inject
    public ElementJsonPostProcessor(PropertyManager propertyManager, FileIO fileIO, CluecumberLogger logger) {
        this.propertyManager = propertyManager;
        this.fileIO = fileIO;
        this.logger = logger;
    }

    public void postDeserialize(Element element, JsonElement jsonElement, Gson gson) {
        element.setFailOnPendingOrUndefined(this.propertyManager.isFailScenariosOnPendingOrUndefinedSteps());
        this.processAttachments(element.getSteps(), element.getAfter());
    }

    private void processAttachments(List<Step> steps, List<ResultMatch> afterHooks) {
        for (Step step : steps) {
            for (ResultMatch before : step.getBefore()) {
                this.processEmbedding(before.getEmbeddings());
            }
            this.processEmbedding(step.getEmbeddings());
            for (ResultMatch after : step.getAfter()) {
                this.processEmbedding(after.getEmbeddings());
            }
        }
        for (ResultMatch afterHook : afterHooks) {
            this.processEmbedding(afterHook.getEmbeddings());
        }
    }

    private void processEmbedding(List<Embedding> embeddings) {
        for (Embedding embedding : embeddings) {
            String filename = this.saveEmbeddingToFileAndGetFilename(embedding);
            embedding.setFilename(filename);
            ++this.attachmentIndex;
        }
    }

    private String saveEmbeddingToFileAndGetFilename(Embedding embedding) {
        String fileEnding = "." + embedding.getFileEnding();
        byte[] dataBytes = Base64.decodeBase64((byte[])embedding.getData().getBytes(StandardCharsets.UTF_8));
        String filename = String.format("attachment%03d%s", this.attachmentIndex, fileEnding);
        try {
            this.fileIO.writeContentToFile(dataBytes, this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments/" + filename);
        }
        catch (FileCreationException e) {
            this.logger.error("Could not process image " + filename + " but will continue report generation...");
        }
        embedding.encodeData(embedding.getData());
        embedding.setData("");
        return filename;
    }

    public void postSerialize(JsonElement jsonElement, Element element, Gson gson) {
    }
}

