/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.json.pojo;

import com.google.gson.annotations.SerializedName;
import com.trivago.cluecumber.constants.MimeType;
import com.trivago.cluecumber.rendering.pages.renderering.RenderingUtils;
import java.nio.charset.StandardCharsets;
import org.codehaus.plexus.util.Base64;

public class Embedding {
    private String data;
    private String decodedData;
    @SerializedName(value="mime_type")
    private MimeType mimeType = MimeType.UNKNOWN;
    private String name = "";
    private boolean isExternalContent;
    private transient String filename = "";

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getDecodedData() {
        return this.decodedData;
    }

    public void decodeData(String data) {
        this.decodedData = new String(Base64.decodeBase64((byte[])data.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        switch (this.mimeType) {
            case HTML: {
                this.decodedData = this.decodedData.replaceAll("\"", "'").replaceAll("&", "&amp;").replaceAll("\"", "&quot;");
                break;
            }
            case XML: 
            case APPLICATION_XML: {
                this.decodedData = this.decodedData.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
                break;
            }
            case TXT: 
            case PDF: 
            case MP4: {
                this.isExternalContent = RenderingUtils.isUrl(this.decodedData);
                break;
            }
        }
    }

    public MimeType getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(MimeType mimeType) {
        this.mimeType = mimeType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isImage() {
        return this.mimeType == MimeType.PNG || this.mimeType == MimeType.GIF || this.mimeType == MimeType.BMP || this.mimeType == MimeType.JPEG || this.mimeType == MimeType.JPG || this.mimeType == MimeType.SVG || this.mimeType == MimeType.SVG_XML;
    }

    public boolean isPlainText() {
        return this.mimeType.getContentType().equalsIgnoreCase("text/plain");
    }

    public String getFileEnding() {
        switch (this.mimeType) {
            case HTML: 
            case XML: 
            case APPLICATION_XML: 
            case PNG: 
            case GIF: 
            case BMP: 
            case JPG: 
            case JPEG: 
            case JSON: {
                return this.mimeType.getContentType().substring(this.mimeType.getContentType().indexOf(47) + 1);
            }
            case SVG: 
            case SVG_XML: {
                return "svg";
            }
            case TXT: {
                return "txt";
            }
            case PDF: {
                return "pdf";
            }
        }
        return "unknown";
    }

    public boolean isExternalContent() {
        return this.isExternalContent;
    }
}

