/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.properties;

import com.trivago.cluecumber.exceptions.CluecumberPluginException;
import com.trivago.cluecumber.filesystem.FileIO;
import com.trivago.cluecumber.properties.LinkedProperties;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertiesFileLoader {
    private final FileIO fileIO;

    @Inject
    public PropertiesFileLoader(FileIO fileIO) {
        this.fileIO = fileIO;
    }

    LinkedHashMap<String, String> loadPropertiesMap(String propertiesFilePath) throws CluecumberPluginException {
        String content = this.fileIO.readContentFromFile(propertiesFilePath);
        LinkedProperties properties = new LinkedProperties();
        try {
            properties.load(new StringReader(content));
        }
        catch (IOException e) {
            throw new CluecumberPluginException("Could not parse properties file '': " + e.getMessage());
        }
        LinkedHashMap propertiesMap = properties.entrySet().stream().collect(Collectors.toMap(propertyEntry -> (String)propertyEntry.getKey(), propertyEntry -> (String)propertyEntry.getValue(), (a, b) -> b, LinkedHashMap::new));
        return propertiesMap;
    }
}

