/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.twitter.common.args.Arg;
import com.twitter.common.args.ArgFilters;
import com.twitter.common.args.Args;
import com.twitter.common.args.ArgumentInfo;
import com.twitter.common.args.OptionInfo;
import com.twitter.common.args.ParserOracle;
import com.twitter.common.args.Parsers;
import com.twitter.common.args.PositionalInfo;
import com.twitter.common.args.Verifiers;
import com.twitter.common.args.apt.Configuration;
import com.twitter.common.collections.Pair;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class ArgScanner {
    private static final Function<OptionInfo, String> GET_OPTIONINFO_NAME = new Function<OptionInfo, String>(){

        public String apply(OptionInfo optionInfo) {
            return optionInfo.getName();
        }
    };
    public static final Ordering<OptionInfo> ORDER_BY_NAME = Ordering.natural().onResultOf(GET_OPTIONINFO_NAME);
    private static final Function<String, String> ARG_NAME_TO_FLAG = new Function<String, String>(){

        public String apply(String argName) {
            return "-" + argName;
        }
    };
    private static final Predicate<OptionInfo> IS_BOOLEAN = new Predicate<OptionInfo>(){

        public boolean apply(OptionInfo optionInfo) {
            return optionInfo.isBoolean();
        }
    };
    private static final String DANGLING_ASSIGNMENT_RE = String.format("^-%s", "[\\w\\-\\.]+");
    private static final Pattern DANGLING_ASSIGNMENT_PATTERN = Pattern.compile(DANGLING_ASSIGNMENT_RE);
    private static final Pattern ASSIGNMENT_PATTERN = Pattern.compile(String.format("%s=.+", DANGLING_ASSIGNMENT_RE));
    private static final Function<OptionInfo, String> GET_OPTIONINFO_NEGATED_NAME = new Function<OptionInfo, String>(){

        public String apply(OptionInfo optionInfo) {
            return optionInfo.getNegatedName();
        }
    };
    private static final Function<OptionInfo, String> GET_CANONICAL_ARG_NAME = new Function<OptionInfo, String>(){

        public String apply(OptionInfo optionInfo) {
            return optionInfo.getCanonicalName();
        }
    };
    private static final Function<OptionInfo, String> GET_CANONICAL_NEGATED_ARG_NAME = new Function<OptionInfo, String>(){

        public String apply(OptionInfo optionInfo) {
            return optionInfo.getCanonicalNegatedName();
        }
    };
    private static final Logger LOG = Logger.getLogger(ArgScanner.class.getName());
    private static final Pattern ARG_PATTERN = Pattern.compile(String.format("-(%s)(?:(?:=| +)(.*))?", "[\\w\\-\\.]+"));
    private static final Pattern QUOTE_PATTERN = Pattern.compile("(['\"])([^\\\u0001]*)\\1");
    private final PrintStream out;

    public ArgScanner() {
        this(System.out);
    }

    public ArgScanner(PrintStream out) {
        this.out = (PrintStream)Preconditions.checkNotNull((Object)out);
    }

    public boolean parse(Iterable<String> args) {
        return this.parse(ArgFilters.SELECT_ALL, args);
    }

    public boolean parse(Predicate<Field> filter, Iterable<String> args) {
        Configuration configuration = this.load();
        Args.ArgumentInfo argumentInfo = Args.fromConfiguration(configuration, filter);
        return this.parse(argumentInfo, configuration, args);
    }

    public boolean parse(Args.ArgumentInfo argumentInfo, Iterable<String> args) {
        Configuration configuration = this.load();
        return this.parse(argumentInfo, configuration, args);
    }

    private boolean parse(Args.ArgumentInfo argumentInfo, Configuration configuration, Iterable<String> args) {
        Parsers parserOracle = Parsers.fromConfiguration(configuration);
        Verifiers verifiers = Verifiers.fromConfiguration(configuration);
        Pair<ImmutableMap<String, String>, List<String>> results = ArgScanner.mapArguments(args);
        return this.process(parserOracle, verifiers, argumentInfo, (Map)results.getFirst(), (List)results.getSecond());
    }

    private Configuration load() {
        try {
            return Configuration.load();
        }
        catch (IOException e) {
            throw new ArgScanException(e);
        }
    }

    @VisibleForTesting
    static List<String> joinKeysToValues(Iterable<String> args) {
        ArrayList joinedArgs = Lists.newArrayList();
        String unmappedKey = null;
        for (String arg : args) {
            if (unmappedKey == null) {
                if (DANGLING_ASSIGNMENT_PATTERN.matcher(arg).matches()) {
                    unmappedKey = arg;
                    continue;
                }
                joinedArgs.add(arg);
                continue;
            }
            if (ASSIGNMENT_PATTERN.matcher(arg).matches()) {
                joinedArgs.add(unmappedKey);
                joinedArgs.add(arg);
                unmappedKey = null;
                continue;
            }
            if (DANGLING_ASSIGNMENT_PATTERN.matcher(arg).find()) {
                joinedArgs.add(unmappedKey);
                unmappedKey = arg;
                continue;
            }
            joinedArgs.add(unmappedKey + "=" + arg);
            unmappedKey = null;
        }
        if (unmappedKey != null) {
            joinedArgs.add(unmappedKey);
        }
        return joinedArgs;
    }

    private static String stripQuotes(String str) {
        Matcher matcher = QUOTE_PATTERN.matcher(str);
        return matcher.matches() ? matcher.group(2) : str;
    }

    private static Pair<ImmutableMap<String, String>, List<String>> mapArguments(Iterable<String> args) {
        ImmutableMap.Builder argMap = ImmutableMap.builder();
        ArrayList positionalArgs = Lists.newArrayList();
        for (String arg : ArgScanner.joinKeysToValues(args)) {
            if (!arg.startsWith("-")) {
                positionalArgs.add(arg);
                continue;
            }
            Matcher matcher = ARG_PATTERN.matcher(arg);
            Preconditions.checkArgument((boolean)matcher.matches(), (Object)String.format("Argument '%s' does not match required format -arg_name=arg_value", arg));
            String rawValue = matcher.group(2);
            rawValue = rawValue == null ? "" : ArgScanner.stripQuotes(rawValue);
            argMap.put((Object)matcher.group(1), (Object)rawValue);
        }
        return Pair.of((Object)argMap.build(), (Object)positionalArgs);
    }

    private static <T> Set<T> dropCollisions(Iterable<T> input) {
        HashSet copy = Sets.newHashSet();
        HashSet collisions = Sets.newHashSet();
        for (T entry : input) {
            if (copy.add(entry)) continue;
            collisions.add(entry);
        }
        copy.removeAll(collisions);
        return copy;
    }

    private static Set<String> getNoCollisions(Iterable<? extends OptionInfo<?>> optionInfos) {
        Iterable argShortNames = Iterables.transform(optionInfos, GET_OPTIONINFO_NAME);
        Iterable argShortNegNames = Iterables.transform((Iterable)Iterables.filter(optionInfos, IS_BOOLEAN), GET_OPTIONINFO_NEGATED_NAME);
        Iterable argAllShortNames = Iterables.concat((Iterable)argShortNames, (Iterable)argShortNegNames);
        Set<String> argAllShortNamesNoCollisions = ArgScanner.dropCollisions(argAllShortNames);
        Sets.SetView collisionsDropped = Sets.difference((Set)ImmutableSet.copyOf((Iterable)argAllShortNames), argAllShortNamesNoCollisions);
        if (!collisionsDropped.isEmpty()) {
            LOG.warning("Found argument name collisions, args must be referenced by canonical names: " + collisionsDropped);
        }
        return argAllShortNamesNoCollisions;
    }

    private boolean process(ParserOracle parserOracle, Verifiers verifiers, Args.ArgumentInfo argumentInfo, Map<String, String> args, List<String> positionalArgs) {
        if (!Sets.intersection(args.keySet(), ArgumentInfo.HELP_ARGS).isEmpty()) {
            this.printHelp(verifiers, argumentInfo);
            return false;
        }
        Optional<? extends PositionalInfo<?>> positionalInfoOptional = argumentInfo.getPositionalInfo();
        Preconditions.checkArgument((positionalInfoOptional.isPresent() || positionalArgs.isEmpty() ? 1 : 0) != 0, (Object)"Positional arguments have been supplied but there is no Arg annotated to received them.");
        Iterable<? extends OptionInfo<?>> optionInfos = argumentInfo.getOptionInfos();
        HashSet argsFailedToParse = Sets.newHashSet();
        HashSet argsConstraintsFailed = Sets.newHashSet();
        Set<String> argAllShortNamesNoCollisions = ArgScanner.getNoCollisions(optionInfos);
        ImmutableMap argsByName = ImmutableMap.builder().putAll((Map)Maps.uniqueIndex((Iterable)Iterables.filter(optionInfos, (Predicate)Predicates.compose((Predicate)Predicates.in(argAllShortNamesNoCollisions), GET_OPTIONINFO_NAME)), GET_OPTIONINFO_NAME)).putAll((Map)Maps.uniqueIndex(optionInfos, GET_CANONICAL_ARG_NAME)).putAll((Map)Maps.uniqueIndex((Iterable)Iterables.filter((Iterable)Iterables.filter(optionInfos, IS_BOOLEAN), (Predicate)Predicates.compose((Predicate)Predicates.in(argAllShortNamesNoCollisions), GET_OPTIONINFO_NEGATED_NAME)), GET_OPTIONINFO_NEGATED_NAME)).putAll((Map)Maps.uniqueIndex((Iterable)Iterables.filter(optionInfos, IS_BOOLEAN), GET_CANONICAL_NEGATED_ARG_NAME)).build();
        Sets.SetView recognizedArgs = Sets.intersection(argsByName.keySet(), args.keySet());
        for (String argName : recognizedArgs) {
            String argValue = args.get(argName);
            OptionInfo optionInfo = (OptionInfo)argsByName.get(argName);
            try {
                optionInfo.load(parserOracle, argName, argValue);
            }
            catch (IllegalArgumentException e) {
                argsFailedToParse.add(argName + " - " + e.getMessage());
            }
        }
        if (positionalInfoOptional.isPresent()) {
            PositionalInfo positionalInfo = (PositionalInfo)positionalInfoOptional.get();
            positionalInfo.load(parserOracle, positionalArgs);
        }
        TreeSet commandLineArgumentInfos = Sets.newTreeSet();
        Iterable allArguments = argumentInfo.getOptionInfos();
        if (positionalInfoOptional.isPresent()) {
            PositionalInfo positionalInfo = (PositionalInfo)positionalInfoOptional.get();
            allArguments = Iterables.concat(optionInfos, (Iterable)ImmutableList.of((Object)positionalInfo));
        }
        for (ArgumentInfo anArgumentInfo : allArguments) {
            Arg arg = anArgumentInfo.getArg();
            commandLineArgumentInfos.add(String.format("%s (%s): %s", anArgumentInfo.getName(), anArgumentInfo.getCanonicalName(), arg.uncheckedGet()));
            try {
                anArgumentInfo.verify(verifiers);
            }
            catch (IllegalArgumentException e) {
                argsConstraintsFailed.add(anArgumentInfo.getName() + " - " + e.getMessage());
            }
        }
        ImmutableMultimap warningMessages = ImmutableMultimap.builder().putAll((Object)"Unrecognized arguments", (Iterable)Sets.difference(args.keySet(), argsByName.keySet())).putAll((Object)"Failed to parse", (Iterable)argsFailedToParse).putAll((Object)"Value did not meet constraints", (Iterable)argsConstraintsFailed).build();
        if (!warningMessages.isEmpty()) {
            this.printHelp(verifiers, argumentInfo);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry warnings : warningMessages.asMap().entrySet()) {
                sb.append((String)warnings.getKey()).append(":\n\t").append(Joiner.on((String)"\n\t").join((Iterable)warnings.getValue())).append("\n");
            }
            throw new IllegalArgumentException(sb.toString());
        }
        LOG.info("-------------------------------------------------------------------------");
        LOG.info("Command line argument values");
        for (String commandLineArgumentInfo : commandLineArgumentInfos) {
            LOG.info(commandLineArgumentInfo);
        }
        LOG.info("-------------------------------------------------------------------------");
        return true;
    }

    private void printHelp(Verifiers verifiers, Args.ArgumentInfo argumentInfo) {
        ImmutableList optional;
        ImmutableList required;
        ImmutableList<String> constraints;
        Object defaultValue;
        Arg arg;
        ImmutableList.Builder requiredHelps = ImmutableList.builder();
        ImmutableList.Builder optionalHelps = ImmutableList.builder();
        for (OptionInfo optionInfo : ORDER_BY_NAME.immutableSortedCopy(argumentInfo.getOptionInfos())) {
            arg = optionInfo.getArg();
            defaultValue = arg.uncheckedGet();
            constraints = this.collectConstraints(verifiers, optionInfo);
            String help = this.formatHelp(optionInfo, (Iterable<String>)constraints, defaultValue);
            if (!arg.hasDefault()) {
                requiredHelps.add((Object)help);
                continue;
            }
            optionalHelps.add((Object)help);
        }
        this.infoLog("-------------------------------------------------------------------------");
        this.infoLog(String.format("%s to print this help message", Joiner.on((String)" or ").join(Iterables.transform(ArgumentInfo.HELP_ARGS, ARG_NAME_TO_FLAG))));
        Optional<? extends PositionalInfo<?>> positionalInfoOptional = argumentInfo.getPositionalInfo();
        if (positionalInfoOptional.isPresent()) {
            this.infoLog("\nPositional args:");
            PositionalInfo positionalInfo = (PositionalInfo)positionalInfoOptional.get();
            arg = positionalInfo.getArg();
            defaultValue = arg.uncheckedGet();
            constraints = this.collectConstraints(verifiers, positionalInfo);
            this.infoLog(String.format("%s%s\n\t%s\n\t(%s)", defaultValue != null ? "default " + defaultValue : "", Iterables.isEmpty(constraints) ? "" : " [" + Joiner.on((String)", ").join(constraints) + "]", positionalInfo.getHelp(), positionalInfo.getCanonicalName()));
        }
        if (!(required = requiredHelps.build()).isEmpty()) {
            this.infoLog("\nRequired flags:");
            this.infoLog(Joiner.on((char)'\n').join((Iterable)required));
        }
        if (!(optional = optionalHelps.build()).isEmpty()) {
            this.infoLog("\nOptional flags:");
            this.infoLog(Joiner.on((char)'\n').join((Iterable)optional));
        }
        this.infoLog("-------------------------------------------------------------------------");
    }

    private ImmutableList<String> collectConstraints(Verifiers verifierOracle, ArgumentInfo<?> argumentInfo) {
        ImmutableList.Builder builder = ImmutableList.builder();
        argumentInfo.collectConstraints(verifierOracle, (ImmutableList.Builder<String>)builder);
        return builder.build();
    }

    private String formatHelp(ArgumentInfo<?> argumentInfo, Iterable<String> constraints, @Nullable Object defaultValue) {
        return String.format("-%s%s%s\n\t%s\n\t(%s)", argumentInfo.getName(), defaultValue != null ? "=" + defaultValue : "", Iterables.isEmpty(constraints) ? "" : " [" + Joiner.on((String)", ").join(constraints) + "]", argumentInfo.getHelp(), argumentInfo.getCanonicalName());
    }

    private void infoLog(String msg) {
        this.out.println(msg);
    }

    public static class ArgScanException
    extends RuntimeException {
        public ArgScanException(Throwable cause) {
            super(cause);
        }
    }
}

