/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.args;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.twitter.common.args.CmdLine;
import com.twitter.common.args.OptionInfo;
import com.twitter.common.args.Positional;
import com.twitter.common.args.PositionalInfo;
import com.twitter.common.args.apt.Configuration;
import java.lang.reflect.Field;
import java.util.logging.Logger;

final class Args {
    @VisibleForTesting
    static final Function<Configuration.ArgInfo, Optional<Field>> TO_FIELD = new Function<Configuration.ArgInfo, Optional<Field>>(){

        public Optional<Field> apply(Configuration.ArgInfo info) {
            try {
                return Optional.of((Object)Class.forName(info.className).getDeclaredField(info.fieldName));
            }
            catch (NoSuchFieldException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new Configuration.ConfigurationException((Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                LOG.fine(String.format("Not on current classpath, skipping %s", info));
                return Optional.absent();
            }
        }
    };
    private static final Logger LOG = Logger.getLogger(Args.class.getName());
    private static final Function<Field, OptionInfo<?>> TO_OPTIONINFO = new Function<Field, OptionInfo<?>>(){

        public OptionInfo<?> apply(Field field) {
            CmdLine cmdLine = field.getAnnotation(CmdLine.class);
            if (cmdLine == null) {
                throw new Configuration.ConfigurationException("No @CmdLine Arg annotation for field " + field, new Object[0]);
            }
            return OptionInfo.createFromField(field);
        }
    };
    private static final Function<Field, PositionalInfo<?>> TO_POSITIONALINFO = new Function<Field, PositionalInfo<?>>(){

        public PositionalInfo<?> apply(Field field) {
            Positional positional = field.getAnnotation(Positional.class);
            if (positional == null) {
                throw new Configuration.ConfigurationException("No @Positional Arg annotation for field " + field, new Object[0]);
            }
            return PositionalInfo.createFromField(field);
        }
    };

    private Args() {
    }

    static ArgumentInfo fromConfiguration(Configuration configuration, Predicate<Field> filter) {
        ImmutableSet positionalFields = ImmutableSet.copyOf(Args.filterFields(configuration.positionalInfo(), filter));
        if (positionalFields.size() > 1) {
            throw new IllegalArgumentException(String.format("Found %d fields marked for @Positional Args after applying filter - only 1 is allowed:\n\t%s", positionalFields.size(), Joiner.on((String)"\n\t").join((Iterable)positionalFields)));
        }
        Iterable positionalInfos = Iterables.transform((Iterable)positionalFields, TO_POSITIONALINFO);
        PositionalInfo positionalInfoOrNull = (PositionalInfo)Iterables.getOnlyElement((Iterable)positionalInfos, null);
        Optional positionalInfoOptional = Optional.fromNullable((Object)positionalInfoOrNull);
        Iterable optionInfos = Iterables.transform(Args.filterFields(configuration.optionInfo(), filter), TO_OPTIONINFO);
        return new ArgumentInfo(positionalInfoOptional, optionInfos);
    }

    private static Iterable<Field> filterFields(Iterable<Configuration.ArgInfo> infos, Predicate<Field> filter) {
        return Iterables.filter((Iterable)Optional.presentInstances((Iterable)Iterables.transform(infos, TO_FIELD)), filter);
    }

    static class ArgumentInfo {
        private final Optional<? extends PositionalInfo<?>> positionalInfo;
        private final Iterable<? extends OptionInfo<?>> optionInfos;

        ArgumentInfo(Optional<? extends PositionalInfo<?>> positionalInfo, Iterable<? extends OptionInfo<?>> cmdLineDescs) {
            this.positionalInfo = (Optional)Preconditions.checkNotNull(positionalInfo);
            this.optionInfos = (Iterable)Preconditions.checkNotNull(cmdLineDescs);
        }

        Optional<? extends PositionalInfo<?>> getPositionalInfo() {
            return this.positionalInfo;
        }

        Iterable<? extends OptionInfo<?>> getOptionInfos() {
            return this.optionInfos;
        }
    }
}

